#!/usr/bin/perl -w
###########################################################
#
#SVMcon: SVM contact map prediction 
#configure.pl: to configure the installation of SVMcon 
#
#Author: Jianlin Cheng
#
#All rights reserved.
##########################################################

#######Customize settings here#############################
#
#set installation directory of SVMcon 
$install_dir = "/home/jcheng/svmcon/";

#set the fullpath of prosys bin directory
#$pspro_dir = "/var/cheng/prosys/";
$pspro_dir = "/home/jcheng/sspro4/";
#
######End of Customization#################################


################Don't Change the code below##############
if (! -d $install_dir)
{
	die "can't find installation directory.\n";
}
if ( substr($install_dir, length($install_dir) - 1, 1) ne "/" )
{
	$install_dir .= "/"; 
}
if (! -d $pspro_dir)
{
	die "can't find Pspro directory.\n";
}
if ( substr($pspro_dir, length($pspro_dir) - 1, 1) ne "/" )
{
	$pspro_dir .= "/"; 
}

#check if the installation directory is right
#the configuration file must run in the installation directory
$cur_dir = `pwd`;  
chomp $cur_dir; 
$configure_file = "$cur_dir/configure.pl";
if (! -f $configure_file || $install_dir ne "$cur_dir/")
{
	die "Please check the installation directory setting and run the configure program there.\n";
}

$bin_dir = "${install_dir}bin/";
$model_dir = "${install_dir}model/";
$script_dir = "${install_dir}script/";
$server_dir = "${install_dir}server/";

if ( ! -d $bin_dir || ! -d $model_dir || ! -d $script_dir
   || ! -d $server_dir )
{
	die "some sub directories don't exist. check the installation tar ball.\n";
}

#generate model definition file
$svm_exe = "${server_dir}svm_classify";
$svmcon_sh = "${bin_dir}predict_map.sh";
$svmcon_model = "${model_dir}/model.g3";
$pspro_exe = "${pspro_dir}bin/predict_ss_sa.sh"; 

print "generate svmcon server script...\n";
open(SERVER_SH, ">$svmcon_sh") || die "can't write diso shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict contact map for one sequence using SVM.\n";
print SERVER_SH "if [ \$# -ne 2 ]\n";
print SERVER_SH "then\n\techo \"need 2 parameters:fasta seq_file, output file.\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_map.pl $install_dir/script $pspro_exe $svm_exe $svmcon_model \$1 \$2 \n"; 
close SERVER_SH;

`chmod 755 $svmcon_sh`; 


