//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stdio.h>
#include <float.h>

#include "../util/Util.hpp"
#include "Mbr.hpp"

Mbr::Mbr()
{
	xl = DBL_MAX;
	xh = DBL_MIN;
	yl = DBL_MAX;
	yh = DBL_MIN;
}

//-----------------------------------------
double Mbr::getEnlargement(pQuery q)
{
	Mbr new_mbr;

	new_mbr.xl = Util::dmin(xl, q->x);
	new_mbr.xh = Util::dmax(xh, q->x + q->x_sz);
	new_mbr.yl = Util::dmin(yl, q->y);
	new_mbr.yh = Util::dmax(yh, q->y + q->y_sz);

	return new_mbr.getArea() - getArea();
}

//-----------------------------------------
double Mbr::getEnlargement(pMbr mbr)
{
	Mbr new_mbr;

	new_mbr.xl = Util::dmin(xl, mbr->xl);
	new_mbr.xh = Util::dmax(xh, mbr->xh);
	new_mbr.yl = Util::dmin(yl, mbr->yl);
	new_mbr.yh = Util::dmax(yh, mbr->yh);

	return new_mbr.getArea() - getArea();
}

//-----------------------------------------
double Mbr::getArea()
{
	return (xh - xl) * (yh - yl);
}


//-----------------------------------------
void Mbr::init(pQuery q)
{
	xl = q->x;
	xh = q->x + q->x_sz;
	yl = q->y;
	yh = q->y + q->y_sz;
}

//-----------------------------------------
void Mbr::adjust(pQuery q)
{
	xl = Util::dmin(xl, q->x);
	xh = Util::dmax(xh, q->x + q->x_sz);
	yl = Util::dmin(yl, q->y);
	yh = Util::dmax(yh, q->y + q->y_sz);
}

//-----------------------------------------
void Mbr::adjust(Mbr *mbr)
{
	xl = Util::dmin(xl, mbr->xl);
	xh = Util::dmax(xh, mbr->xh);
	yl = Util::dmin(yl, mbr->yl);
	yh = Util::dmax(yh, mbr->yh);
}

//----------------------------- 
bool Mbr::intersectsWith(pPoint p)
{
	return	xl <= p->x &&
			xh >= p->x &&
			yl <= p->y &&
			yh >= p->y;
}

//----------------------------- 
bool Mbr::operator == (Mbr &mbr)
{
	return	xl == mbr.xl && 
			xh == mbr.xh &&
			yl == mbr.yl &&
			yh == mbr.yh;
}

//----------------------------- 
bool Mbr::operator != (Mbr &mbr)
{
	return	xl != mbr.xl ||
			xh != mbr.xh ||
			yl != mbr.yl ||
			yh != mbr.yh;
}

//-----------------------------------------
void Mbr::print()
{
	printf("[%f, %f]x[%f, %f]", xl, xh, yl, yh);
}
