//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef MBR_HPP
#define MBR_HPP 
 
#include "../data/Query.hpp" 
 
class Mbr 
{ 
public: 
	double xl; 
	double xh; 
	double yl; 
	double yh; 
 
	Mbr(); 
 
	double getEnlargement(pQuery q); 
	double getEnlargement(Mbr *mbr); 
 
	double getArea(); 
 
	void init(pQuery q); 
 
	void adjust(pQuery q); 
	void adjust(Mbr *mbr); 
 
	bool intersectsWith(pPoint p); 
 
	bool operator == (Mbr &mbr);  
	bool operator != (Mbr &mbr);  
 
	void print(); 
 
}; 
 
typedef Mbr *pMbr; 
 
#endif 
 
