//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stdio.h>
#include "Query.hpp" 
 
const double ALMOST_ONE = 0.999999;

Query::Query() 
{ 
	orig_q = this;

	x	 = 0; 
	y	 = 0; 
	x_sz = 0; 
	y_sz = 0;
	q2p_list = NULL;
}  


//-----------------------------  
Query::Query(double x, double y, double x_sz, double y_sz)  
{ 
	orig_q = this;
	init(x, y, x_sz, y_sz); 
} 

 
//----------------------------- 
void Query::init(/*int id,*/ double x, double y, double x_sz, double y_sz) 
{  
	//this->id = id; 

	if (x < 0)  x = 0; 
	if (x >= 1) x = ALMOST_ONE; 
 
	if (y < 0)  y = 0; 
	if (y >= 1) y = ALMOST_ONE; 
 
	if (x + x_sz > 1) x_sz = ALMOST_ONE - x; 
	if (y + y_sz > 1) y_sz = ALMOST_ONE - y; 
 
	if (x_sz < 0) x_sz = 0; 
	if (y_sz < 0) y_sz = 0; 
 
	this->x    = x; 
	this->y    = y; 
	this->x_sz = x_sz; 
	this->y_sz = y_sz; 

	this->q2p_list = NULL;
} 


//----------------------------- 
bool Query::intersectsWith(Query *q)
{
	return	x        <= q->x + q->x_sz  &&
			x + x_sz >= q->x            &&
			y        <= q->y + q->y_sz  &&
			y + y_sz >= q->y;
}
 
//----------------------------- 
bool Query::intersectsWith(Rect *q)
{
	return	x        <= q->x + q->x_sz  &&
			x + x_sz >= q->x            &&
			y        <= q->y + q->y_sz  &&
			y + y_sz >= q->y;
}

//----------------------------- 
bool Query::intersectsWith(pPoint p)
{
	return	x        <= p->x &&
			x + x_sz >= p->x &&
			y        <= p->y &&
			y + y_sz >= p->y;
}

//----------------------------- 
void Query::print() 
{ 
	printf("[x=%f, y=%f, x_sz=%f, y_sz=%f]", x, y, x_sz, y_sz); 
} 
 
