//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef QUERY_HPP
#define QUERY_HPP  

#include <memory.h> 
 
#include "Point.hpp" 
#include "../struc/ListNode.hpp" 
#include "Rect.hpp"  

 
class Query 
{ 
public: 
	//-- vars --
	Query *orig_q; // pointer to self -- when copied to find the original 

	double x; 
	double y; 
	double x_sz; 
	double y_sz; 
	 
	pPListNode q2p_list; 
 
 
	//-- functions --
	Query();  
	Query(double x, double y, double x_sz, double y_sz);  

	void init(double x, double y, double x_sz, double y_sz); 
	void print(); 
	 
	bool intersectsWith(Query *q); 
	bool intersectsWith(Rect *q); 
	bool intersectsWith(pPoint p); 
 
 
	//-- functions for R* Tree -- 
	int get_size() {return sizeof(Query);} 
 
	void read_from_buffer(char *buffer) { memcpy(this, buffer, sizeof(Query)); } 
	void write_to_buffer (char *buffer) { memcpy(buffer, this, sizeof(Query)); } 
  
	float* get_mbr()  
	{ 
		float *f = new float[4]; 
		f[0] = (float)x; 
		f[1] = (float)(x + x_sz); 
		f[2] = (float)y; 
		f[3] = (float)(y + y_sz); 
 
		return f; 
	}  
 
};  
 
typedef Query *pQuery;
 
#endif
