//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stdio.h>
#include "Grid.hpp"
#include "../struc/DynArray.hpp"

 
Grid::Grid(int numXCells, int numYCells, double domain_sz) 
{
	g = new Cell[numYCells * numXCells]; 

	if (g == NULL)
	{
		printf("\nCellArr::CellArr() not enought space ");
	}

	this->numXCells = numXCells; 
	this->numYCells = numYCells; 
	this->domain_sz = domain_sz;
	 
	this->hX = domain_sz / numXCells; 
	this->hY = domain_sz / numYCells; 
	  

	//-- init grid -- 
	for (int j = 0; j < numYCells; j++) 
	{ 
		for (int i = 0; i < numXCells; i++) 
		{ 
			(*this)[j][i].fullQry = new DynArray<pQuery>(); 
			(*this)[j][i].partQry = new DynArray<pQuery>(); 
		} 
	} 
} 

//--------------------------------------------
void Grid::addQueryArr(pQuery queryArr, int num_query)
{
	for (int i = 0; i < num_query; i++)
	{
		//printf("\n-- query #%d", i);
		insert(&queryArr[i]);
	}
}
 
//----- DynArray<pQuery> ----------------------------- 
void Grid::getQ2P(Point *pointArr, int num_point, Query *queryArr, int num_query, pPListNode q2pmap)
{
	int i;

	//-- kill previous mapping --
	int map_len =0;

	Query *q = &queryArr[0]; 

	for (i = 0; i < num_query; i++)
	{
		q->q2p_list = NULL;
		q ++;
	}

	
	//-- create new mapping --
	Point *p = &pointArr[0]; 
	
	for (i = 0; i < num_point; i++) 
	{ 
		//-- determine point's cell -- 
		int cell_x = (int) (p->x / hX); 
		int cell_y = (int) (p->y / hY); 
		
		pCell pcell = &(*this)[cell_y][cell_x]; 
	
		int i;
		//-- handle cell's full list --
		//for (pnode = pcell->fullQry->phead; pnode != NULL; pnode = pnode->next) 
		for (i = 0; i < pcell->fullQry->cur_sz; i++)
		{ 
			q = pcell->fullQry->arr[i];

			//-- create new element in q2p map --
			pPListNode map_el = &q2pmap[map_len];
			map_len ++;

			//-- adjust new map element --
			map_el->data = p;
			map_el->next = q->q2p_list;

			//-- adjust q's q2p list
			q->q2p_list = map_el; 
		} 

		
		//-- handle cell's part list -- 
		//for (pnode = pcell->partQry->phead; pnode != NULL; pnode = pnode->next) 
		for (i = 0; i < pcell->partQry->cur_sz; i++)
		{ 
			q = pcell->partQry->arr[i];
			
			//-- if  q contains point p => insert p to q'a answer list -- 
			if ((q->x <= p->x) &&
				(q->y <= p->y) &&
				(q->x + q->x_sz >= p->x) &&
				(q->y + q->y_sz >= p->y) )
			{
				//-- create new element in q2p map --
				pPListNode map_el = &q2pmap[map_len];
				map_len ++;
				
				//-- adjust new map element --
				map_el->data = p;
				map_el->next = q->q2p_list;
				
				//-- adjust q's q2p list
				q->q2p_list = map_el; 
				
			}
		} 
		
	
		//-- next point --
		p ++;
	}
	
	printf("\n Q->P only (map_len = %d)", map_len);
	
} 

//-------------------------------------------------- 
void Grid::insert(Query *q, bool insert_internals) 
{
	// internals are always full
	// perimeter always partial - our simplification/speedup
	int i;
	pCell cell;

	//-- determine set of cells q touches -- 
	int cell_x1 = (int) (q->x / hX); 
	int cell_y1 = (int) (q->y / hY); 
	 
	int cell_x2 = (int) ( (q->x + q->x_sz) / hX); 
	int cell_y2 = (int) ( (q->y + q->y_sz) / hY); 
	 
	//-- handle top side --
	cell = &(*this)[cell_y1][cell_x1];

	for (i = cell_x1; i <= cell_x2; i++) 
	{
		cell->partQry->insert(q); 
		cell ++;
	}


	//-- are we done yet ? --
	if (cell_y2 == cell_y1) 
		return;

	//-- handle bottom side --
	cell = &(*this)[cell_y2][cell_x1];

	for (i = cell_x1; i <= cell_x2; i++) 
	{
		cell->partQry->insert(q);
		cell ++;
	}
	
	//-- handle left side --
	for (i = cell_y1 + 1; i <= cell_y2 - 1; i++)
		(*this)[i][cell_x1].partQry->insert(q);

	//-- are we done yet ? --
	if (cell_x2 == cell_x1) 
		return;

	//-- handle right side --
	for (i = cell_y1 + 1; i <= cell_y2 - 1; i++)
		(*this)[i][cell_x2].partQry->insert(q);

	//-- handle internals --
	if (insert_internals)
	{
		for (int j = cell_y1 + 1; j <= cell_y2 - 1; j++) 
		{ 
			cell = &(*this)[j][cell_x1 + 1];

			for (int i = cell_x1 + 1; i <= cell_x2 - 1; i++) 
			{ 
				cell->fullQry->insert(q);
				cell ++;
			} 
		}
	}
	 
}
 
 
 
//---------------------------------- 
void Grid::remove(Query *q, bool remove_internals) 
{
	// internals are always full
	// perimeter always partial - our simplification/speedup
	int i;
	pCell cell;

	//-- determine set of cells q touches -- 
	int cell_x1 = (int) (q->x / hX); 
	int cell_y1 = (int) (q->y / hY); 
	 
	int cell_x2 = (int) ( (q->x + q->x_sz) / hX); 
	int cell_y2 = (int) ( (q->y + q->y_sz) / hY); 
	 
	//-- handle top side --
	cell = &(*this)[cell_y1][cell_x1];

	for (i = cell_x1; i <= cell_x2; i++) 
	{
		cell->partQry->remove(q); 
		cell ++;
	}


	//-- are we done yet ? --
	if (cell_y2 == cell_y1) 
		return;

	//-- handle bottom side --
	cell = &(*this)[cell_y2][cell_x1];

	for (i = cell_x1; i <= cell_x2; i++) 
	{
		cell->partQry->remove(q);
		cell ++;
	}
	
	//-- handle left side --
	for (i = cell_y1 + 1; i <= cell_y2 - 1; i++)
		(*this)[i][cell_x1].partQry->remove(q);

	//-- are we done yet ? --
	if (cell_x2 == cell_x1) 
		return;

	//-- handle right side --
	for (i = cell_y1 + 1; i <= cell_y2 - 1; i++)
		(*this)[i][cell_x2].partQry->remove(q);

	//-- handle internals --
	if (remove_internals)
	{
		for (int j = cell_y1 + 1; j <= cell_y2 - 1; j++) 
		{ 
			cell = &(*this)[j][cell_x1 + 1];

			for (int i = cell_x1 + 1; i <= cell_x2 - 1; i++) 
			{ 
				cell->fullQry->remove(q);
				cell ++;
			} 
		}
	}
	 
}

//---------------------------------- 
void Grid::moveQuery(Query *q, double dx, double dy)
{
	//-- determine new coordinates --
	double nx = q->x + dx;
	double ny = q->y + dy;

	//-- determine set of cells q touches -- 
	int ocell_x1 = (int) (q->x / hX); 
	int ocell_y1 = (int) (q->y / hY); 
	int ocell_x2 = (int) ( (q->x + q->x_sz) / hX); 
	int ocell_y2 = (int) ( (q->y + q->y_sz) / hY); 

	//-- determine set of cells new q touches -- 
	int ncell_x1 = (int) (nx / hX); 
	int ncell_y1 = (int) (ny / hY); 
	int ncell_x2 = (int) ( (nx + q->x_sz) / hX); 
	int ncell_y2 = (int) ( (ny + q->y_sz) / hY); 
	
	//-- if small move do almost nothing --
	if ((ocell_x1 == ncell_x1) && (ocell_y1 == ncell_y1) && 
		(ocell_x2 == ncell_x2) && (ocell_y2 == ncell_y2))
	{
		//-- just adjust query coordinates --
		q->x += dx;
		q->y += dy;
		
		return;
	}


	//--- more complex movement is needed ---

	//-- compute internal rectangles --
	int ox1 = ocell_x1 + 1;
	int oy1 = ocell_y1 + 1;
	int ox2 = ocell_x2 - 1;
	int oy2 = ocell_y2 - 1;

	int nx1 = ncell_x1 + 1;
	int ny1 = ncell_y1 + 1;
	int nx2 = ncell_x2 - 1;
	int ny2 = ncell_y2 - 1;

	//-- if internals way too small, do dumb move --
	bool internals_too_small =
		(ox2 - ox1 <= 1) ||
		(oy2 - oy1 <= 1) ||
		(nx2 - nx1 <= 1) ||
		(ny2 - ny1 <= 1);

	bool jump_left_too_far  = (nx1 >= ox2);
	bool jump_right_too_far = (nx2 <= ox1);
	bool jump_up_too_far    = (ny2 <= oy1);
	bool jump_down_too_far  = (ny1 >= oy2);

	bool jump_too_far = jump_left_too_far ||
		jump_right_too_far ||
		jump_up_too_far    ||
		jump_down_too_far;

	if (internals_too_small || jump_too_far)
	{
		//-- do dumb move --
		remove(q);

		//-- adjust query coordinates --
		q->x += dx;
		q->y += dy;

		insert(q);

		return;
	}

	//-- here we can get potential gain by not touching intersection --

	//-- remove border of old query --
	remove(q, dont_touch_internals);

	//-- case 1 --
	if (dx >= 0 && dy >= 0)
	{
		int x;
		int y;

		//-- remove top of 'corner' -- 
		for (y = oy1; y < ny1; y++)
		{
			for (x = ox1; x <= ox2; x++)
			{
				(*this)[y][x].fullQry->remove(q);
			}
		}

		//-- remove left of 'corner' -- 
		for (y = ny1; y <= oy2; y++)
		{
			for (x = ox1; x < nx1; x++)
			{
				(*this)[y][x].fullQry->remove(q);
			}
		}

		//-- adjust query coordinates --
		q->x += dx;
		q->y += dy;

		insert(q, dont_touch_internals);

		//-- insert right side --
		for (y = ny1; y <= oy2; y++)
		{
			for (x = ox2 + 1; x <= nx2; x++)
			{
				(*this)[y][x].fullQry->insert(q);
			}
		}

		//-- insert bottom side --
		for (y = oy2 + 1; y <= ny2; y++)
		{
			for (x = nx1; x <= nx2; x++)
			{
				(*this)[y][x].fullQry->insert(q);
			}
		}

		return;
	}

	printf("moveQuery(): case not implemented");
	getchar();

}

//---------------------------------- 
void Grid::moveQuery2(Query *q, double dx, double dy)
{
	//-- determine new coordinates --
	double nx = q->x + dx;
	double ny = q->y + dy;

	//-- determine set of cells q touches -- 
	int ocell_x1 = (int) (q->x / hX); 
	int ocell_y1 = (int) (q->y / hY); 
	int ocell_x2 = (int) ( (q->x + q->x_sz) / hX); 
	int ocell_y2 = (int) ( (q->y + q->y_sz) / hY); 

	//-- determine set of cells new q touches -- 
	int ncell_x1 = (int) (nx / hX); 
	int ncell_y1 = (int) (ny / hY); 
	int ncell_x2 = (int) ( (nx + q->x_sz) / hX); 
	int ncell_y2 = (int) ( (ny + q->y_sz) / hY); 
	
	//-- if small move do almost nothing --
	if ((ocell_x1 == ncell_x1) && (ocell_y1 == ncell_y1) && 
		(ocell_x2 == ncell_x2) && (ocell_y2 == ncell_y2))
	{
		//-- just adjust query coordinates --
		q->x += dx;
		q->y += dy;
		
		return;
	}


	//--- do dumb move ---
	remove(q);

	q->x += dx;
	q->y += dy;

	insert(q);
}


//---------------------------------- 
void Grid::getMaxListSize(int &max_f, int &max_p)
{
	max_f = 0;
	max_p = 0;

	for (int y = 0; y < this->numYCells; y++)
	{
		for (int x = 0; x < this->numXCells; x++)
		{
			int cur_f = (*this)[y][x].fullQry->cur_sz;
			int cur_p = (*this)[y][x].partQry->cur_sz;

			if (max_f < cur_f) max_f = cur_f;
			if (max_p < cur_p) max_p = cur_p;
		}
	}
}
