//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef GRID_HPP
#define GRID_HPP  

#include <stddef.h> 
#include "Cell.hpp" 

const bool do_touch_internals = true;  
const bool dont_touch_internals = false; 
 
class Grid 
{ 
private: 
	Cell *g;	// 2D array of cells a.k.a. CellArr 
 
	int numXCells;  
	int numYCells;  
  
	double domain_sz; 

public: 
	double hX;  
	double hY;  
 

	Grid(int numXCells, int numYCells, double domain_sz = 1.0);  
 
	void addQueryArr(pQuery queryArr, int num_query);  
 
	void insert (Query *q, bool insert_internals = true); 
	void remove (Query *q, bool remove_internals = true);  
 
	void moveQuery  (Query *q, double dx, double dy);  
	void moveQuery2 (Query *q, double dx, double dy); 
  
	void getQ2P(Point *pointArr, int num_point, Query *queryArr, int num_query, pPListNode q2pmap);  

 
	inline pCell operator[] (size_t y) { return &(g[y * numXCells]); }  
 
	//-- statistics functions -- 
	void getMaxListSize(int &max_f, int &max_p);
}; 
 
typedef Grid *pGrid;  
#endif  
 
 

  
 
