//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stdio.h>

#include "../grid/Grid.hpp"


#include "Grid2.hpp"
 
Grid2::Grid2(int numXCells, int numYCells, double domain_sz) 
{
	dir_grid = new Cell2[numYCells * numXCells]; 

	if (dir_grid == NULL)
	{
		printf("\nCellArr::CellArr() not enought space ");
	}

	this->numXCells = numXCells; 
	this->numYCells = numYCells; 
	this->domain_sz = domain_sz;
	 
	this->hX = domain_sz / numXCells; 
	this->hY = domain_sz / numYCells; 
	  
	pGrid grid = new Grid(1000, 1000, 1.0);

	//-- init grid -- 
	for (int j = 0; j < numYCells; j++) 
	{ 
		for (int i = 0; i < numXCells; i++) 
		{ 
			(*this)[j][i].grid = grid; 
		} 
	}
	
	//-- init [0][0] with different grid to handle cluster -- 
	(*this)[0][0].grid = new Grid(1000, 1000, hX);
} 

//--------------------------------------------
void Grid2::addQueryArr(pQuery queryArr, int num_query)
{
	for (int i = 0; i < num_query; i++)
	{
		insert(&queryArr[i]);
	}
}
 
//----- DynArray<pQuery> ----------------------------- 
void Grid2::getQ2P(Point *pointArr, int num_point, Query *queryArr, int num_query, pPListNode q2pmap)
{
	int i;

	//-- kill previous mapping --
	int map_len =0;

	Query *q = &queryArr[0]; 

	for (i = 0; i < num_query; i++)
	{
		q->q2p_list = NULL;
		q ++;
	}

	
	//-- create new mapping --
	Point *p = &pointArr[0]; 
	
	for (i = 0; i < num_point; i++) 
	{ 
		//-- determine which grid to use -- 
		int cell_x = (int) (p->x / hX); 
		int cell_y = (int) (p->y / hY); 
		pGrid grid = (*this)[cell_y][cell_x].grid;

		
		//-- determine points' cell in this grid --
		cell_x = (int) (p->x / grid->hX); 
		cell_y = (int) (p->y / grid->hY); 
		pCell pcell = &(*grid)[cell_y][cell_x]; 

		
		int i;
		//-- handle cell's full list --
		//for (pnode = pcell->fullQry->phead; pnode != NULL; pnode = pnode->next) 
		for (i = 0; i < pcell->fullQry->cur_sz; i++)
		{ 
			q = pcell->fullQry->arr[i];

			//-- create new element in q2p map --
			pPListNode map_el = &q2pmap[map_len];
			map_len ++;

			//-- adjust new map element --
			map_el->data = p;
			map_el->next = q->q2p_list;

			//-- adjust q's q2p list
			q->q2p_list = map_el; 
		} 

		
		//-- handle cell's part list -- 
		//for (pnode = pcell->partQry->phead; pnode != NULL; pnode = pnode->next) 
		for (i = 0; i < pcell->partQry->cur_sz; i++)
		{ 
			q = pcell->partQry->arr[i];
			
			//-- if  q contains point p => insert p to q'a answer list -- 
			if ((q->x <= p->x) &&
				(q->y <= p->y) &&
				(q->x + q->x_sz >= p->x) &&
				(q->y + q->y_sz >= p->y) )
			{
				//-- create new element in q2p map --
				pPListNode map_el = &q2pmap[map_len];
				map_len ++;
				
				//-- adjust new map element --
				map_el->data = p;
				map_el->next = q->q2p_list;
				
				//-- adjust q's q2p list
				q->q2p_list = map_el; 
				
			}
		} 
		
	
		//-- next point --
		p ++;
	}
	
	printf("\n Q->P only (map_len = %d)", map_len);
	
} 

//-------------------------------------------------- 
void Grid2::insert(Query *q) 
{
	//-- determine cell -- 
	int cell_x1 = (int) (q->x / hX); 
	int cell_y1 = (int) (q->y / hY); 
	
	pGrid grid = (*this)[cell_y1][cell_x1].grid;
	grid->insert(q);
}
 
 
 
//---------------------------------- 
void Grid2::remove(Query *q) 
{
	//-- determine cell -- 
	int cell_x1 = (int) (q->x / hX); 
	int cell_y1 = (int) (q->y / hY); 
	
	pGrid grid = (*this)[cell_y1][cell_x1].grid;
	grid->remove(q);
}


//---------------------------------- 
void Grid2::getMaxListSize(int &max_f, int &max_p)
{
	int max_f1;
	int max_p1;

	(*this)[0][0].grid->getMaxListSize(max_f , max_p );
	(*this)[1][1].grid->getMaxListSize(max_f1, max_p1);

	if (max_f < max_f1) max_f = max_f1;
	if (max_p < max_p1) max_p = max_p1;
}

	
