//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef GRID2_HPP
#define GRID2_HPP 

#include <stddef.h> 
#include "Cell2.hpp" 

 
class Grid2 
{ 
private: 
	Cell2 *dir_grid;	// 2D array of cells a.k.a. CellArr

	int numXCells; 
	int numYCells; 
 
	double hX; 
	double hY; 

	double domain_sz;

public: 
	Grid2(int numXCells, int numYCells, double domain_sz = 1.0); 

	void addQueryArr(pQuery queryArr, int num_query); 

	void insert (Query *q);
	void remove (Query *q); 

 
	void getQ2P(Point *pointArr, int num_point, Query *queryArr, int num_query, pPListNode q2pmap); 

 
	inline pCell2 operator[] (size_t y) { return &(dir_grid[y * numXCells]); } 

	//-- statistics functions --
	void getMaxListSize(int &max_f, int &max_p);
}; 
 
typedef Grid2 *pGrid2; 
#endif 



 

