//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stddef.h>
#include <memory.h>
#include "Sort.hpp"

//-----------------------------------------
void Sort::sortPoint(Point *pointArr, int num_point)
{
	Sort *mySort = new Sort(pointArr, num_point);
	Query *domain = new Query(/*-1,*/ 0, 0, 1, 1);

	mySort->sort(domain, 0, num_point);
	mySort->clean();
}

//-----------------------------------------
Sort::Sort(Point *pointArr, int num_point)
{
	this->pointArr = pointArr;
	
	buf[0][0] = new Point[num_point];
	buf[0][1] = new Point[num_point];
	buf[1][0] = new Point[num_point];
	buf[1][1] = new Point[num_point];
}

//-----------------------------------------
void Sort::clean()
{
	pointArr = NULL;

	delete[] buf[0][0];
	delete[] buf[0][1];
	delete[] buf[1][0];
	delete[] buf[1][1];

	buf[0][0] = NULL;
	buf[0][1] = NULL;
	buf[1][0] = NULL;
	buf[1][1] = NULL;
}

//-----------------------------------------
void Sort::sort(Query *domain, int from, int size)
{
	//-- bottom of recursion --
	if (size <= 1 || domain->x_sz < 0.0001) //no sorting is necessary
		return;

	//-- init vars --
	int buf_sz[2][2];
	buf_sz[0][0] = 0;
	buf_sz[0][1] = 0;
	buf_sz[1][0] = 0;
	buf_sz[1][1] = 0;

	double x = domain->x;
	double y = domain->y;
	double x_sz = domain->x_sz;
	double y_sz = domain->y_sz;

	double qx_sz = x_sz / 2.0;
	double qy_sz = y_sz / 2.0;

	Query *dom1 = new Query(/*-1,*/ x        , y        , qx_sz, qy_sz); 
	Query *dom2 = new Query(/*-1,*/ x + qx_sz, y        , qx_sz, qy_sz);
	Query *dom3 = new Query(/*-1,*/ x        , y + qy_sz, qx_sz, qy_sz);
	Query *dom4 = new Query(/*-1,*/ x + qx_sz, y + qy_sz, qx_sz, qy_sz);

	//-- copy points to according buf[][] --
	int to = from + size;
	for (int i = from; i < to; i++)
	{
		Point *point = &pointArr[i];

		//-- get quandrat coordinates for point --
		int xCell = (int) ((point->x - x) / qx_sz);
		int yCell = (int) ((point->y - y) / qy_sz);

		//-- determine proper buffer to store point --
		Point	*cur_buf = buf[yCell][xCell];
		int		*pbuf_sz = &buf_sz[yCell][xCell];

		//-- store point --
		cur_buf[*pbuf_sz] = *point;
		(*pbuf_sz) ++;
	}

	//-- copy points back from buf[][]'s --
	Point *dst;
	Point *src;
	//int size;

	//-- 1 --
	dst = &pointArr[from];
	src = buf[0][0];
	size = buf_sz[0][0] * sizeof(Point);
	memcpy(dst, src, size);

	//-- 2 --
	dst = &pointArr[from + buf_sz[0][0]];
	src = buf[0][1];
	size = buf_sz[0][1] * sizeof(Point);
	memcpy(dst, src, size);

	//-- 3 --
	dst = &pointArr[from + buf_sz[0][0] + buf_sz[0][1]];
	src = buf[1][0];
	size = buf_sz[1][0] * sizeof(Point);
	memcpy(dst, src, size);

	//-- 4 --
	dst = &pointArr[from + buf_sz[0][0] + buf_sz[0][1] + buf_sz[1][0]];
	src = buf[1][1];
	size = buf_sz[1][1] * sizeof(Point);
	memcpy(dst, src, size);

	//-- sort each interval --
	sort(dom1, from                                             , buf_sz[0][0]);
	sort(dom2, from + buf_sz[0][0]                              , buf_sz[0][1]);
	sort(dom3, from + buf_sz[0][0] + buf_sz[0][1]               , buf_sz[1][0]);
	sort(dom4, from + buf_sz[0][0] + buf_sz[0][1] + buf_sz[1][0], buf_sz[1][1]);
	
}

