//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//



#ifndef DYNARRAY_CPP
#define DYNARRAY_CPP

#include <stdio.h>
#include "DynArray.hpp"

//-------------------------
template <class DATA>
DynArray<DATA>::DynArray(int max_sz)
{
	this->max_sz = max_sz;
	this->cur_sz = 0;

	arr = new DATA[max_sz];
}

//-------------------------
template <class DATA>
DynArray<DATA>::~DynArray()
{
	delete arr;
}
 
//-------------------------
template <class DATA>
void DynArray<DATA>::insert(DATA q)
{
	//-- check if need to generate new array --
	if (cur_sz >= max_sz)
	{
		//-- allocate new array --
		DATA  *new_arr = new DATA[max_sz * 2];

		//-- copy old stuff to new array --
		memcpy(new_arr, arr, sizeof(DATA) * max_sz);

		//-- delete old array --
		delete arr;

		//-- adjust list --
		arr = new_arr;
		max_sz *= 2;
	}

	arr[cur_sz] = q;
	cur_sz ++;
}


//-------------------------
template <class DATA>
void DynArray<DATA>::remove(DATA q)
{
	int find_i = -1;

	for (int i = 0; i < cur_sz; i++)
	{
		if (arr[i] == q)
		{
			find_i = i;
			break;
		}
	}

	if (find_i == -1)
	{
		printf("\nDynArray::remove() attempt to delete non-existing entry");
		getchar();

		return;
	}

	arr[find_i] = arr[cur_sz - 1];
	cur_sz --;
}

//-----------------------------
template <class DATA>
bool DynArray<DATA>::isEmpty()
{
	return cur_sz == 0;
} 

//-----------------------------
template <class DATA>
void DynArray<DATA>::print() {;} 

#endif

