//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef LIST_CPP
#define LIST_CPP

#include <stdio.h> 
 
#include "List.hpp" 

//------------------------- 
template <class DATA>
List<DATA>::List() 
{ 
	phead = NULL; 
} 
//------------------------- 
template <class DATA>
List<DATA>::~List() 
{ 
	while( get() != NULL)
		;
} 
 
//------------------------- 
template <class DATA>
bool List<DATA>::isEmpty()
{
	return phead == NULL;
} 

 
//------------------------- 
template <class DATA>
void List<DATA>::insert(DATA data) 
{ 
	phead = new ListNode<DATA>(data, phead); 
}
 

//------------------------- 
template <class DATA>
DATA List<DATA>::get() 
{ 
	if (phead == NULL)
		return NULL;

	DATA data = phead->data;

	ListNode<DATA> *tmp = phead;
	phead = phead->next;

	delete tmp;

	return data;
} 

 
//-------------------------  
template <class DATA>
void List<DATA>::remove(DATA data)  
{  
	//-- handle empty list -- 
	if ( isEmpty() ) 
	{ 
		printf("\nList::remove() - attempt to delete from empty list"); 
		getchar(); 
 
		return; 
	} 
		 
	//-- handle case when data is first elem -- 
	if (phead->data == data) 
	{ 
		ListNode<DATA> *tmp = phead; 
		phead = tmp->next; 
 
		delete tmp; 
		return; 
	} 
 
	//-- data is not the first elem -- 
	ListNode<DATA> *prev_node = phead; 
 
	for (ListNode<DATA> *cur_node = phead->next; cur_node != NULL; cur_node = cur_node->next) 
	{ 
		if (cur_node->data == data) 
		{ 
			//-- remove cur_node -- 
			prev_node->next = cur_node->next; 
 
			delete cur_node; 
 
			return; 
		} 
 
		prev_node = cur_node; 
	} 
 
	printf("\nList::remove() - specified queue is not found in list"); 
	getchar(); 
	 
	return; 
} 
 
//------------------------- 
template <class DATA>
void List<DATA>::print() 
{ 
	for (ListNode<DATA> *pnode = phead; pnode != NULL; pnode = pnode->next) 
	{ 
		pnode->data->print(); 
	} 
}

#endif

