#include <stdio.h> 
#include <stdlib.h>
 
#include "grid/Grid.hpp"
//#include "grid2/Grid2.hpp"
//#include "qtree/QTree.hpp" 
//#include "rstar/rtree.h"
//#include "ctree/CTree.hpp"
//#include "mtree/MTree.hpp"
//#include "ktree/KTree.hpp"
 
#include "data/Query.hpp" 
#include "data/Point.hpp" 
#include "util/Timer.hpp"  
#include "util/Util.hpp" 

#include "struc/List.hpp"
#include "sort/Sort.hpp"

#include "const.h"

#define MAP2

 
int main(int argc, char* argv[]) 
{ 
	if (argc != 10)
	{
		printf("USAGE: index nXcell nYcell query_perc query_sz skewed num_point num_query navq_sz nav_stepX\n\n");
		getchar();
		return -1;
	}

	int numXCells = atoi(argv[1]); //1000; 
	int numYCells = atoi(argv[2]); //1000;

	double query_perc = atof(argv[3]); //10;
	//double query_sz   = atof(argv[4]); //0.01;
	double x_sz = atof(argv[4]); //0.01;
	double y_sz = x_sz;


	int skewed = atoi(argv[5]); // 0, 1, 2

	int num_point = atoi(argv[6]) * 1000; //250000; 
	int num_query = atof(argv[7]) * 1000; //25000;

	//-- navigation params --
	//double q_sz  = atof(argv[8]);
	//double stepX = atof(argv[9]);



	printf("\n num_point=%dK", num_point / 1000);
	printf("\n num_query=%dK", num_query / 1000);
	printf("\n");
	//printf("\n query_sz  =%f", query_sz);
	printf("\n x_sz  =%f", x_sz);
	printf("\n y_sz  =%f", y_sz);
	printf("\n query_perc=%f", query_perc);
	printf("\n");
	printf("\n numXCells =%d", numXCells);
	printf("\n numYCells =%d", numYCells);
	printf("\n");
	printf("\n skewed    =%d", skewed);
	printf("\n");

  
	//printf("\nq=%d", sizeof(Query));
	//getchar();

	Timer *timer = new Timer();  
 
	//--- generate points --- 
	printf ("\nGenerating points  ... "); 
	timer->start();

	Point *pointArr = new Point[num_point + 1]; // last point has x = -1

	if      (skewed == 0) Util::genPoint       (pointArr, num_point);  
	else if (skewed == 1) Util::genSkewedPoint1(pointArr, num_point); 
	else                  Util::genSkewedPoint2(pointArr, num_point); 

	printf("%f secs", timer->getTime()); 

	//-- sort points --
	/*printf ("\nSorting points  ... "); 
	timer->start();
	Sort::sortPoint(pointArr, num_point);
	printf("%f secs", timer->getTime()); */
	

	
	//--- generate queries --- 
	printf ("\nGenerating queries ... "); 
	timer->start();
	
	Query *queryArr;

	if      (skewed == 0) queryArr = Util::genQuery(num_query, x_sz, y_sz);   
	else if (skewed == 1) queryArr = Util::genSkewedQuery1(num_query, x_sz, y_sz);   
	else                  queryArr = Util::genSkewedQuery2(num_query, x_sz, y_sz);   
		

	printf("%f secs", timer->getTime()); 


	/*//-- sort queries --
	printf ("\nSorting queries  ... "); 
	timer->start();
	//SortQuery::sortQuery(queryArr, num_query);
	printf("%f secs", timer->getTime()); */

	
	//-- allocate memory for map --
	printf ("\nAllocating memory for map ... "); 
	timer->start();
	pPListNode q2pmap = new ListNode<pPoint>[MAX_MAP_SZ];
	
	if (q2pmap == NULL)
	{
		printf("\nIndex::Index(): cannot allocate memory for Q2P map");
		exit(-1);
	}
	printf("%f secs", timer->getTime()); 


	//-- create index -- 
	printf ("\nCreating index ..."); 
	timer->start();

	//-- Grid --
	printf(" Grid ");
	Grid *index = new Grid(numXCells, numYCells);  

	//printf(" Grid2 ");
	//Grid2 *index = new Grid2(numXCells, numYCells);  

	//-- 32x32 Tree --
	//printf("\n32x32 Tree");
	//KTree *index = new KTree();

	//-- Quad Tree --
	//printf("\nQuad Tree");
	//QTree *index = new QTree();

	//-- R* Tree --
	//printf(" R* Tree");
	//RTree<Query> *index = new RTree<Query>("test.rt", 250, 4, 2);


	//-- R Tree --
	//printf(" R Tree ");
	//CTree *index = new CTree(5);

	//-- M Tree --
	//printf(" CR Tree ");
	//MTree *index = new MTree(5);



	printf(" %f secs", timer->getTime()); 


	//-- Adding queries to index -- 
	printf ("\nAdding queries to index ... "); 
	timer->start();
	index->addQueryArr(queryArr, num_query);
	printf("%f secs", timer->getTime()); 

	//int max_f;
	//int max_p;

    //printf("\n Measure space");
    //getchar();
    //exit(-1);

	//index->getMaxListSize(max_f, max_p);
	//printf("\n\nmax_f = %d; max_p = %d\n\n", max_f, max_p);

	//return 0;
	
	for (int j = 0; j < 200; j++)
	{
		//-- processing --
		printf ("\nDo processing ... "); 
		timer->start();
		index->getQ2P(pointArr, num_point, queryArr, num_query, q2pmap);	 
		printf ("%f secs", timer->getTime());
		
		
		//-- move points --
		printf ("\nmoving points ... "); 
		timer->start();

		if      (skewed == 0) Util::genPoint       (pointArr, num_point);  
		else if (skewed == 1) Util::genSkewedPoint1(pointArr, num_point); 
		else                  Util::genSkewedPoint2(pointArr, num_point); 

		printf ("%f secs", timer->getTime());
	}


	//-- navigation queries --
	/*const double stepY = stepX / 2.0;
	const double eps = 0.000001;
	const int max_steps = 90; //(int) ((1 - q_sz) / stepX);
	const int max_runs = 100;
	int k;

	Query *q = new Query(eps, eps, q_sz, q_sz);

	printf ("\n\n--- navigation section ---");
	printf ("\n q_sz =%f\n stepX=%f\n stepY=%f\n max_steps=%d\n max_runs =%d",
		q_sz, stepX, stepY, max_steps, max_runs);  


	printf ("\nNavigation: dumb  (%f, %f)... ", q->x, q->y);  
	timer->start();
	
	for (k = 0; k < max_runs; k++)
	{
		q->x = eps;
		q->y = eps;

		index->addQuery(q);
		
		for (int i = 0; i < max_steps; i++)
		{
			index->removeQuery(q);
			
			q->x += stepX;
			q->y += stepY;
			
			index->addQuery(q);
		}
		index->removeQuery(q);
	}

	printf ("(%f, %f) : %f secs", q->x, q->y, timer->getTime());
	

	q->x = eps;
	q->y = eps;

	printf ("\nNavigation: smart (%f, %f)... ", q->x, q->y);  
	timer->start(); 

	for (k = 0; k < max_runs; k++)
	{
		q->x = eps;
		q->y = eps;
		
		index->addQuery(q);
		
		for (int i = 0; i < max_steps; i++)
		{
			index->moveQuery(q, stepX, stepY);
		}
		index->removeQuery(q);
	}

	printf ("(%f, %f) : %f secs", q->x, q->y, timer->getTime());

	q->x = eps;
	q->y = eps;

	printf ("\nNavigation: smart2(%f, %f)... ", q->x, q->y);  
	timer->start(); 

	for (k = 0; k < max_runs; k++)
	{
		q->x = eps;
		q->y = eps;
		
		index->addQuery(q);
		
		for (int i = 0; i < max_steps; i++)
		{
			index->moveQuery2(q, stepX, stepY);
		}
		index->removeQuery(q);
	}

	printf ("(%f, %f) : %f secs", q->x, q->y, timer->getTime());

	printf ("\n--- end navigation section ---\n");



	//-- test arrival & removal query speed --
	int num_modif_query = (int) (num_query * query_perc / 100.0);

	printf ("\nAdding/removing %f percent of queries ... ", query_perc);  
	timer->start(); 

	for (int i = 0; i < num_modif_query; i++)
	{
		//-- add or remove query with probability of 0.5
		if (Util::rnd() < 0.5)
		{
			index->addQuery(&queryArr[i]);
			continue;
		}

		index->removeQuery(&queryArr[i]);
	}

	printf ("%f secs", timer->getTime());

	//-- remove all queries from index -- for testing -- 
	//printf ("\nRemoving queries ... ");  
	//timer->start(); 
	//for (i = num_query - 1; i >= 0; i--) 
	//for (i = 0; i < num_query; i++) 
	//{ 
	//	index->removeQuery( &queryArr[i] ); 
	//} 
	//printf ("%f secs", timer->getTime());  
	

	*/
	getchar(); 
	

	delete timer; 
	delete[] pointArr; 
	delete[] queryArr; 

	printf("\n\n");

	return 0; 
}
