//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#include <stdio.h>
#include <math.h> 

#include "../const.h"
 
#include "../data/Query.hpp" 
#include "../data/Point.hpp" 
 
#include "Util.hpp" 


//------------------------------------- 
double Util::dmin(double a, double b)
{
	if (a < b) return a;
	else return b;
}

//------------------------------------- 
double Util::dmax(double a, double b)
{
	if (a > b) return a;
	else return b;
}

//------------------------------------- 
uchar Util::umin(uchar a, uchar b)
{
	if (a < b) return a;
	else return b;
}

//------------------------------------- 
uchar Util::umax(uchar a, uchar b)
{
	if (a > b) return a;
	else return b;
}

 
//------------------------------------- 
double Util::rnd() 
{ 
	const double d2p31m = 2147483647.0; 
	const double d2p31  = 2147483711.0; 
 
	static double seed = 1234567.0; //init only one time 
 
	seed = 16807 * seed - floor(16807 * seed / d2p31m) * d2p31m; 
 
	return fabs(seed / d2p31);  
}  
 
//-------------------------------------  
double Util::rndNormal01()  
{ 
	double v1, v2, s; 
 
	do 
	{ 
		v1 = 2 * rnd() - 1; 
		v2 = 2 * rnd() - 1; 
 
		s = v1 * v1 + v2 * v2; 
	} 
	while (s >= 1); 
 
	return v1 * sqrt((- 2 * log(s)) / s); 
} 
 
//-------------------------------------  
double Util::rndNormal(double mean, double stddev) 
{ 
	double r; 
 
	while (true) 
	{ 
		r = stddev * rndNormal01() + mean; 
 
		if (r > 0 && r < 1) 
			return r; 
	} 
} 

 
//------------------------------------- 
/*Query* Util::genQuery(int num_qry, double query_sz) 
{ 
	printf(" uniform query ");

	Query *queryArr = new Query [num_qry + 1]; 
 
	for (int i = 0; i < num_qry; i++) 
	{ 
		queryArr[i].init(rnd(), rnd(), query_sz, query_sz); 
	} 
 
	queryArr[num_qry].x = -1; 
 
	return queryArr; 
} */

//------------------------------------- 
Query* Util::genQuery(int num_qry, double x_sz, double y_sz) 
{ 
	printf(" query ~U, query sides ~S ");

	Query *queryArr = new Query [num_qry + 1]; 
 
	for (int i = 0; i < num_qry; i++) 
	{
		//-- // swap values of x_sz and y_sz to generate "|" and "--" queries --
		if (rnd() > 0.5)
		{
			double tmp = x_sz;
			x_sz = y_sz;
			y_sz = tmp;
		}

		queryArr[i].init(/*i,*/ rnd(), rnd(), x_sz, y_sz); 
	} 
 
	queryArr[num_qry].x = -1; 
 
	return queryArr; 
} 

//------------------------------------- 
void Util::genPoint(Point* pointArr, int num_point) 
{ 
	printf(" uniform point ");

	for (int i = 0; i < num_point; i++) 
	{ 
		pointArr[i].init(rnd(), rnd()); 
	} 
 
	pointArr[num_point].x = -1; 
}  
 

//-------------------------------------   
void Util::genSkewedPoint1(Point* pointArr, int num_point)  
{ 
	printf(" skewed-point#1 ");

	int point_in_cluster = num_point / 5;
 
	//-- init cluster centers --
	Point *center1 = new Point(0.2, 0.2); 
	Point *center2 = new Point(0.8, 0.2); 
	Point *center3 = new Point(0.2, 0.8); 
	Point *center4 = new Point(0.8, 0.8); 
	Point *center5 = new Point(0.5, 0.5); 
 
	//-- create clusters --
	genPointCluster(center1, point_dev, pointArr,                    0, point_in_cluster); 
	genPointCluster(center2, point_dev, pointArr,     point_in_cluster, point_in_cluster); 
	genPointCluster(center3, point_dev, pointArr, 2 * point_in_cluster, point_in_cluster); 
	genPointCluster(center4, point_dev, pointArr, 3 * point_in_cluster, point_in_cluster); 
	genPointCluster(center5, point_dev, pointArr, 4 * point_in_cluster, point_in_cluster); 
  
	pointArr[5 * point_in_cluster].x = -1;  

	delete center1;
	delete center2;
	delete center3;
	delete center4;
	delete center5;
}  

//-------------------------------------   
void Util::genSkewedPoint2(Point* pointArr, int num_point)  
{
	printf(" skewed-point#2 ");

	genPoint(pointArr, num_point);

	for (int i = 0; i < num_point; i += 2)
	{
		pointArr[i].x /= 1000.0;
		pointArr[i].y /= 1000.0;
	}
} 

//-------------------------------------   
/*Query* Util::genSkewedQuery1(int num_query, double query_sz)  
{ 
	printf(" skewed-query#1 ");

	int query_in_cluster = num_query / 5; 
	 
	//-- create array for queries --
	Query *queryArr = new Query[num_query + 1];  
 
	//-- init cluster centers --
	Point *center1 = new Point(0.2, 0.2); 
	Point *center2 = new Point(0.8, 0.2); 
	Point *center3 = new Point(0.2, 0.8); 
	Point *center4 = new Point(0.8, 0.8); 
	Point *center5 = new Point(0.5, 0.5); 
 
	//-- create clusters --
	genQueryCluster(center1, query_dev, queryArr,                    0, query_in_cluster, query_sz); 
	genQueryCluster(center2, query_dev, queryArr,     query_in_cluster, query_in_cluster, query_sz); 
	genQueryCluster(center3, query_dev, queryArr, 2 * query_in_cluster, query_in_cluster, query_sz); 
	genQueryCluster(center4, query_dev, queryArr, 3 * query_in_cluster, query_in_cluster, query_sz); 
	genQueryCluster(center5, query_dev, queryArr, 4 * query_in_cluster, query_in_cluster, query_sz); 
  
	queryArr[5 * query_in_cluster].x = -1;  

	delete center1;
	delete center2;
	delete center3;
	delete center4;
	delete center5;
  
	return queryArr;  
}*/

//-------------------------------------   
Query* Util::genSkewedQuery1(int num_query, double x_sz, double y_sz)  
{ 
	// Apr 26, 2003
	printf(" skewed-query#1 of various sizes");

	int query_in_cluster = num_query / 5; 
	 
	//-- create array for queries --
	Query *queryArr = new Query[num_query + 1];  
 
	//-- init cluster centers --
	Point *center1 = new Point(0.2, 0.2); 
	Point *center2 = new Point(0.8, 0.2); 
	Point *center3 = new Point(0.2, 0.8); 
	Point *center4 = new Point(0.8, 0.8); 
	Point *center5 = new Point(0.5, 0.5); 
 
	//-- create clusters --
	genQueryCluster(center1, query_dev, queryArr,                    0, query_in_cluster, x_sz, y_sz); 
	genQueryCluster(center2, query_dev, queryArr,     query_in_cluster, query_in_cluster, x_sz, y_sz); 
	genQueryCluster(center3, query_dev, queryArr, 2 * query_in_cluster, query_in_cluster, x_sz, y_sz); 
	genQueryCluster(center4, query_dev, queryArr, 3 * query_in_cluster, query_in_cluster, x_sz, y_sz); 
	genQueryCluster(center5, query_dev, queryArr, 4 * query_in_cluster, query_in_cluster, x_sz, y_sz); 
  
	queryArr[5 * query_in_cluster].x = -1;  

	delete center1;
	delete center2;
	delete center3;
	delete center4;
	delete center5;
  
	return queryArr;  
}


//-------------------------------------   
Query* Util::genSkewedQuery2(int num_query, double x_sz, double y_sz)  
{ 
	printf(" skewed-query#2 ");

	Query *queryArr = genQuery(num_query, x_sz, y_sz);

	for (int i = 0; i < num_query; i += 2)
	{
		pQuery q = &queryArr[i];

		//-- // swap values of x_sz and y_sz to generate "|" and "--" queries --
		if (rnd() > 0.5)
		{
			double tmp = x_sz;
			x_sz = y_sz;
			y_sz = tmp;
		}

		q->x /= 1000.0;
		q->y /= 1000.0;
		q->x_sz /= 1000.0;
		q->y_sz /= 1000.0;

		q = &queryArr[i + 1];

		while (q->x <= 0.001 && q->y <= 0.001) //in cell [0][0]
			q->init(rnd(), rnd(), x_sz, y_sz); 
	}

	return queryArr;
}
   
 
//-------------------------------------   
void Util::genPointCluster(Point *center, double std_dev, Point *pointArr, int from, int size) 
{ 
	int to = from + size; 
 
	for (int i = from; i < to; i++) 
	{ 
		pointArr[i].x = rndNormal(center->x, std_dev); 
		pointArr[i].y = rndNormal(center->y, std_dev); 
	} 
} 
 
//-------------------------------------   
/*void Util::genQueryCluster(Point *center, double std_dev, Query *queryArr, int from, int cluster_sz, double query_sz) 
{ 
	double z; 
 
	int to = from + cluster_sz; 
 
	for (int i = from; i < to; i++) 
	{ 
		Query *q = &queryArr[i]; 
 
		//q->id = i; 
 
		//-- generate x -- 
		z = rndNormal(center->x, std_dev); 
 
		if (z + query_sz > 1) 
			z -= query_sz; 
 
		q->x = z; 
 
		//-- generate y -- 
		z = rndNormal(center->y, std_dev); 
 
		if (z + query_sz > 1) 
			z -= query_sz; 
 
		q->y = z; 
 
		//-- set size -- 
		q->x_sz = query_sz; 
		q->y_sz = query_sz; 
	} 
}*/


//-------------------------------------   
void Util::genQueryCluster(Point *center, double std_dev, Query *queryArr, int from, int cluster_sz, double x_sz, double y_sz) 
{ 
	double z; 
 
	int to = from + cluster_sz; 
 
	for (int i = from; i < to; i++) 
	{ 
		Query *q = &queryArr[i]; 
 
		//q->id = i; 

		//-- // swap values of x_sz and y_sz to generate "|" and "--" queries --
		if (rnd() > 0.5)
		{
			double tmp = x_sz;
			x_sz = y_sz;
			y_sz = tmp;
		}
 
		//-- generate x -- 
		z = rndNormal(center->x, std_dev); 
 
		if (z + x_sz > 1) 
			z -= x_sz; 
 
		q->x = z; 
 
		//-- generate y -- 
		z = rndNormal(center->y, std_dev); 
 
		if (z + y_sz > 1) 
			z -= y_sz; 
 
		q->y = z; 
 
		//-- set size -- 
		q->x_sz = x_sz; 
		q->y_sz = y_sz; 
	} 
}
