//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain without change as the 3 top lines of this file.
//


#ifndef UTIL_HPP
#define UTIL_HPP  
 

#include "../data/Point.hpp" 
#include "../data/Query.hpp" 
 
//#include "../mtree/QMbr.hpp" 

typedef unsigned char uchar;
 
class Util 
{ 
public:   
	 

	//-- random number generators --
	static double rnd();  
	static double rndNormal01(); 
	static double rndNormal(double mean, double stddev); 
 
	//-- data generators --
	
	static void genPoint(Point* pointArr, int num_point);  
	static void genSkewedPoint1(Point* pointArr, int num_point);    
	static void genSkewedPoint2(Point* pointArr, int num_point);   
 
	
	static Query* genQuery(int num_query, double x_sz, double y_sz);  
	static Query* genSkewedQuery1(int num_query, double x_sz, double y_sz);  
	static Query* genSkewedQuery2(int num_query, double x_sz, double y_sz);  
 
	static void genPointCluster(Point *center, double std_dev, Point *pointArr, int from, int size); 
	static void genQueryCluster(Point *center, double std_dev, Query *queryArr, int from, int cluster_sz, double x_sz, double y_sz); 
 
	static double dmin(double a, double b); 
	static double dmax(double a, double b); 
 
	static uchar umin(uchar a, uchar b); 
	static uchar umax(uchar a, uchar b); 
 
 
 
}; 
 
#endif
