#include <stdio.h>
#include <string.h>

#include "../nbh/GrdNBH.hpp"
#include "../util/Util.hpp"
//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//



#include "../const.hpp"

#include "Choice.hpp"

extern HashStr<int> fnid2feid;
extern Hash<pFullEdge> edgeTable;

extern int gAPMaxNodes;
extern int gAPL;
extern int gNBHMaxNodes;
extern int gNBHL;


//--
Choice::Choice(int id, int type, char* name, int cnt_fnode_id, int ans_fnode_id, bool addToT) : FullNode(id, type, name, addToT)
{
	this->cnt_fnode_id = cnt_fnode_id;
	this->ans_fnode_id = ans_fnode_id;

	if (addToT)
		choiceTable.insert(this);

}

//--
Choice::~Choice()  
{
	nodeTable.remove(id);
	choiceTable.remove(this);
	delete name;
}

//--
void Choice::init()
{
	//-- init arrays for paths --
	int num_edges = edges.cur_sz;
	num_opt = num_edges - 1;
	paths	= new DynArrayInt[num_opt]();
	fix_w	= new double[num_opt];
	dyn_w	= new double[num_opt];
	is_fixed= new bool[num_opt];


	//---------------------------------------------
	// make options be first and context_entity be last
	// also check consistency of the choice 

	//-- find conext edge --
	unsigned int a[2];
	if (id < cnt_fnode_id) { a[0] = id; a[1] = cnt_fnode_id; }
	else                   { a[0] = cnt_fnode_id; a[1] = id; }

	int cnt_edge_id = fnid2feid.get((unsigned char*)a, sizeof(int)*2);

	//-- find answer edge --	
	bool ans_fnode_found;
	int ans_edge_id = -100;

	if (ans_fnode_id >= 0)
	{
		//-- the answer is provided --
		ans_fnode_found = false;	// do check for this node later	

		if (id < ans_fnode_id) { a[0] = id; a[1] = ans_fnode_id; }
		else                   { a[0] = ans_fnode_id; a[1] = id; }

		ans_edge_id = fnid2feid.get((unsigned char*)a, sizeof(int)*2);
	}
	else
		ans_fnode_found = true;		//don't check for the node

	for (int i = 0; i < num_opt; i++)
	{
		if (edges.arr[i] == cnt_edge_id)
		{
			int tmp = edges.arr[num_opt];
			edges.arr[num_opt] = cnt_edge_id;
			edges.arr[i] = tmp;
		}

		if (edges.arr[i] == ans_edge_id)
			ans_fnode_found = true;
			

		fix_w[i] = 0;
		dyn_w[i] = 0;
		is_fixed[i] = true;

		int edge_id = edges.arr[i];
		pFullEdge edge = edgeTable.get(edge_id);
		edge->w = 1.0 / num_opt;
	}

	//--
	if (!ans_fnode_found) 
	{
		printf("\n Choice(%d): answer edge not found", id);
		exit(-1);
	}


	//--
	if (edges.arr[num_opt] != cnt_edge_id)
	{
		printf("\n Choice(%d): context edge not found", id);
		exit(-1);
	}
}


//--
void Choice::findPaths(GrdNBH &nbh)
{
	//printf("\n w1");
	//-- compute dstNode --
	pFullNode dstFNode = nodeTable.get(cnt_fnode_id);
	pNode dstNode = dstFNode->cnode;

	//printf("\n w2");
	//-- build neighborhood --
	nbh.build(dstNode, nodeArr, gNBHL, gNBHMaxNodes);

	//-- get compact version of the choice --
	pNode ccho = this->cnode;


	//printf("\n w3");
	//-- find context->opt_i paths --
	for (int i = 0; i < num_opt; i++)
	{
		pNode srcNode = ccho->edges[i];
		grdAllPathsNBH(srcNode, &nbh, gAPL, gAPMaxNodes, nodeArr, this, i);
	}

	//printf("\n w4");
}


//--
void Choice::addPath(pPathEl path, pNode dstNode, int opt_no)
{
	//-- prepare path --
	int  fnode_ids[100];
	pFullNode fnode_arr[100];
	pPathEl tmp_path = path;
	int path_len = path->len;
	

	//-- 0-1-2-3-dstNode --
	for (int i = path_len; i >= 0; i--)
	{
		pNode cnode = tmp_path->node;
		tmp_path = tmp_path->prv_el;

		fnode_arr[i] = cnode->fnode; 
		fnode_ids[i] = fnode_arr[i]->id;

		/*cnode->print();
		printf("\n x fni=%d", fnode_ids[i]);
		cnode->fnode->print();*/
	}
	
	fnode_arr[path_len + 1] = dstNode->fnode;
	fnode_ids[path_len + 1] = fnode_arr[path_len + 1]->id;



	//-- check if the path is legal  --
	for (int i = 1; i <= path->len; i++)
	{
		//-- problems only with choice nodes --
		if (fnode_arr[i]->type != CHOICE_NODE)
			continue;

		//-- the path must not go via this choice --
		if (fnode_arr[i] == this)
			return;

		//-- must be context-cho-opt only --
		pChoice cho = (pChoice)fnode_arr[i];
		pFullNode context_node = nodeTable.get(cho->cnt_fnode_id);

		if (fnode_arr[i-1] != context_node && fnode_arr[i+1] != context_node)
			return;
	}


	//-- the path is legal --
	double fix_w2;
	double dyn_w2;
	bool is_fixed2;

	computePathWeight(fnode_ids, path->len + 1, fix_w2, dyn_w2, is_fixed2);

	fix_w[opt_no] += fix_w2;
	dyn_w[opt_no] += dyn_w2;


	if (is_fixed2) return;


	//-- the path is dynamic, thus must be added --
	is_fixed[opt_no] = false;
	fnode_ids[0] = path_len + 1;

	/*printf("path:");
	for (int i = 0; i < path_len + 1; i ++)
		printf(" %d:%d", i, fnode_ids[i]);

	getchar();*/

	paths[opt_no].insertk(fnode_ids, path_len + 1);
}


//--
void Choice::propagateWeights()
{
	//Reflect computed weights on the choice option-edges.

	//-- find sum_w --
	double sum_w = 0;

	for (int i = 0; i < num_opt; i++)
	{
		sum_w = sum_w + fix_w[i] + dyn_w[i]; 
	}

	//-- reassign weights for each option --
	if (sum_w == 0)
	{
		for (int i = 0; i < num_opt; i++)
		{
			int edge_id = edges.arr[i];
			pFullEdge edge = edgeTable.get(edge_id);
			edge->w = 1.0 / num_opt;
		}
	}
	else
	{
		for (int i = 0; i < num_opt; i++)
		{
			int edge_id = edges.arr[i];
			pFullEdge edge = edgeTable.get(edge_id);
			edge->w = (fix_w[i] + dyn_w[i]) / sum_w;
		}
	}
}


//--
void Choice::propagateAllWeights()
{
	for (int i = 0; i < choiceTable.cur_sz; i++)
	{
		pChoice cho = choiceTable.arr[i];
		cho->propagateWeights();
	}
}


//--
void Choice::recomputeWeights()
{
	// Scan through *already discovered* paths. 
	int fnode_ids[100];
	int path_len;

	for (int i = 0; i < num_opt; i++)
	{
		//-- if the weight is fixed, then don't even bother --
		if (is_fixed[i])
			continue;
		
		//-- will recompute only dynamic weigts --
		dyn_w[i] = 0.0;
		
		fnode_ids[0] = cnode->edges[i]->fnode->id;
		DynArrayInt *path_arr = &paths[i];

		for (int j = 0; j < path_arr->cur_sz; j += path_len)
		{
			path_len = path_arr->arr[j];
			memcpy(&(fnode_ids[1]), &(path_arr->arr[j+1]), sizeof(int)*(path_len-1));
			fnode_ids[path_len] = cnt_fnode_id;
			
			double fix_w2;
			double dyn_w2;
			bool is_fixed2;

			computePathWeight(fnode_ids, path_len, fix_w2, dyn_w2, is_fixed2);
			
			dyn_w[i] += fix_w2 + dyn_w2; // alternatively, fixed paths must be removed!!!
		}
	}
}

//--
/*void Choice::recomputeAllWeights()
{
	for (int i = 0; i < choiceTable.cur_sz; i++)
	{
		pChoice cho = choiceTable.arr[i];
		cho->recomputeWeights();
	}
}*/
