//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//


#ifndef CHOICE_HPP
#define CHOICE_HPP

#include "FullNode.hpp"

class Node;
class PathEl;
class GrdNBH;

typedef DynArray<int> DynArrayInt;

class Choice : public FullNode
{
public:
	int cnt_fnode_id;	// id of the context node
	int ans_fnode_id;	// the true match, -1 if 
	int num_opt;	// = num_edges - 1;

	DynArrayInt *paths;	// for edges - options:first, context:last
	double *fix_w;
	double *dyn_w;
	bool *is_fixed;


	//-- constructor --
	Choice(){;}
	Choice(int id, int type, char* name, int cnt_fnode_id, int ans_fnode_id, bool addToT);
	virtual ~Choice();

	void init();
	void findPaths(GrdNBH &nbh);
	void addPath(PathEl *path, Node *dstNode, int opt_no);
	void propagateWeights();
	void recomputeWeights(); 
	static void propagateAllWeights();
	static void recomputeAllWeights(); 
};

typedef Choice *pChoice;


#endif
