//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <string.h>

#include "FullEdge.hpp"
#include "FullNode.hpp"
#include "../util/Hash.hpp"
#include "../util/HashStr.hpp"


extern HashStr<int> fnid2feid;
extern Hash<pFullNode> nodeTable;
extern Hash<pFullEdge> edgeTable;
extern int gChoiceNodeT;


//-----------------------
FullEdge::FullEdge(int id, int fnode_id1, int fnode_id2, int type, char* name, bool addToET, double w)
{
	if (id < 0) id = next_uid ++;
	else 		next_uid = __max(id + 1, next_uid);

	//-- check if id already exists --
	if (edgeTable.get(id) != NULL)
	{
			printf("\n FullEdge(): edge with id=%d already exists, skipping", id);
			getchar();
			return;
	}

	this->id = id;
	this->fnode_id1 = fnode_id1;
	this->fnode_id2 = fnode_id2;
	this->type = type;
	this->name = strdup(name);
	this->w = w;

	if (fnode_id1 == fnode_id2)
	{
		printf("\n FullEdge(): fnid1=fnid2. An error is likely.");
		getchar();
	}

	//-- insert the edge into nodes --
	pFullNode fnode1 = nodeTable.get(fnode_id1);
	pFullNode fnode2 = nodeTable.get(fnode_id2);

	if (fnode1 == NULL || fnode2 == NULL)
	{
		printf("\n FullEdge(): In edge_id=%d, node [ID=%d] or [ID=%d] does not exist.\n\n", id, fnode_id1, fnode_id2);
		exit(-1);
	}
	
	fnode1->edges.insert(id);
	fnode2->edges.insert(id);


	//-- add to edgeTable --
	if (addToET)
	{
		edgeTable.insert(id, this);

		//-- add this edge to fnid2feid map --
		int a[2];
		unsigned char* p = (unsigned char*)&a[0];

		if (fnode_id1 < fnode_id2)	{ a[0] = fnode_id1; a[1] = fnode_id2; }
		else						{ a[0] = fnode_id2; a[1] = fnode_id1; }

		fnid2feid.insert(p, sizeof(int) * 2, id);
	}
}

//-----------------------
FullEdge::~FullEdge()
{
	//-- remove from the edge table --
	edgeTable.remove(id);


	//-- remove from the two nodes --
	pFullNode fnd1 = nodeTable.get(fnode_id1);
	pFullNode fnd2 = nodeTable.get(fnode_id2);

	fnd1->edges.remove(id);
	fnd2->edges.remove(id);


	//-- remove this edge from fnid2feid map --
	int a[2];
	unsigned char* p = (unsigned char*)&a[0];

	if (fnode_id1 < fnode_id2)	{ a[0] = fnode_id1; a[1] = fnode_id2; }
	else						{ a[0] = fnode_id2; a[1] = fnode_id1; }

	fnid2feid.remove(p, sizeof(int) * 2, id);

	//--
	delete name;
	
}

//-----------------------
void FullEdge::print()
{
	printf("FullEdge[id=%d, nd1=%d, nd2=%d, t=%d, name=%s]", 
		id, fnode_id1, fnode_id2, type, name);
}


//-----------------------
void FullEdge::save(FILE *f)
{
	pFullNode fnode1 = nodeTable.get(fnode_id1);
	pFullNode fnode2 = nodeTable.get(fnode_id2);

	if (fnode1->type == gChoiceNodeT || fnode2->type == gChoiceNodeT)
		return;

	fprintf(f, "edge: { source: \"%d\" target: \"%d\" color: %d }\n", fnode_id1, fnode_id2, type -10);
}

