//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <string.h>

#include "../util/Hash.hpp"
#include "FullNode.hpp"
#include "FullEdge.hpp"

extern Hash<pFullNode> nodeTable;
extern Hash<pFullEdge> edgeTable;
extern int gChoiceNodeT;

//--
FullNode::FullNode(int id, int type, char* name, bool addToT)
{
	if (id < 0) id = next_uid ++;
	else 		next_uid = __max(id + 1, next_uid);

	//-- check if id already exists --
	if (nodeTable.get(id) != NULL)
	{
		printf("\n FullNode(): node with id=%d already exists, skipping", id);
		getchar();
		return;
	}

	this->id   = id;
	this->type = type;
	this->name = strdup(name);

	if (addToT)
		nodeTable.insert(id, this);

}

//--
FullNode::~FullNode()
{
	//-- unlink all incident edges --
	while (edges.cur_sz > 0)
	{
		pFullEdge fedge = edgeTable.get(edges.arr[0]);

		if (fedge == NULL)
		{
			printf("\n ~FullNode(): an error while deleting edge id = %d", edges.arr[0]);
			exit(-1);
		}
		
		delete fedge; // will remove itself from nodes
	}

	nodeTable.remove(id);
	delete name;
}

//--
void FullNode::print()
{
	printf("[node_id=%d, name=%s]", id, name);
}

//--
void FullNode::save(FILE *f)
{
	if (this->type == gChoiceNodeT)
		return;

	fprintf(f, "node: { title: \"%d\" label: \"%s\" color: %d } \n", id, name, type + 3);
}

