//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//



#include <stdio.h>
#include <stdlib.h>

//-- CS Model --
#include "model/ETM.hpp"
#include "model/PLM.hpp"
#include "model/PLM2.hpp"
#include "model/PCM.hpp"
#include "model/PCM2.hpp"
#include "model/WM.hpp"

#include "util/Config.hpp"
#include "util/HashStr.hpp"
#include "util/Util.hpp"

#include "const.hpp"

//-- externs --
extern void outputResults();
extern void eliminateDeadends();
extern void saveGraphForVis(char *filename);

//-- config --
const char DEFAULT_CONFIG_FILE[]  = "config/config.xml";
const char REALPUB_CONFIG_FILE[]  = "config/config.xml.RealPub";
const char REALMOV_CONFIG_FILE[]  = "config/config.xml.RealMov";   
Config conf(DEFAULT_CONFIG_FILE);


//-- global tables --
Hash<pFullNode> nodeTable(conf.get_int((char*)"ApproxNumberNodes")); 
Hash<pFullEdge> edgeTable(conf.get_int((char*)"ApproxNumberEdges"));
DynArray<pChoice> choiceTable;
pNode nodeArr;
HashStr<int> fnid2feid(conf.get_int((char*)"ApproxNumberEdges"));
pModel cs_model;


//-- global parameters --
int gAPMaxNodes;
int gAPL;
int gNBHMaxNodes;
int gNBHL;
int gChoiceNodeT;

int FullNode::next_uid = -1;
int FullEdge::next_uid = -1;

//-- Main --
int main()//int argc, char* argv[])
{
	printf("\n RelDC Engine v1.00.  ");
	Timer::print();


	//-- init global params --
	gAPMaxNodes  = conf.get_int((char*)"APMaxNodes");
	gAPL		 = conf.get_int((char*)"APL");
	gNBHMaxNodes = conf.get_int((char*)"NBHMaxNodes");
	gNBHL		 = conf.get_int((char*)"NBHL");
	gChoiceNodeT = conf.get_int((char*)"ChoNodeType");

	//-- init CS model --
	int model_ty = conf.get_int((char*)"CSModelType");

	switch(model_ty)
	{
	case 1: {cs_model = new ETM(); break; }
	//case 2: {cs_model = new PTM(); break; }
	case 3: {cs_model = new PCM(); break; }
	case 4: {cs_model = new PLM(); break; }
	case 5: {cs_model = new  WM(); break; }
	case 6: {cs_model = new PCM2(); break;}
	case 7: {cs_model = new PLM2(); break;}

	default: {printf("\n main(): Unknown CS Model"); exit(-1);}
	};

	printf("\n CS Model: ");
	cs_model->print();


	//-- load data from files --
	loadNodes(conf.get_str((char*)"NodeFileName"));
	loadEdges(conf.get_str((char*)"EdgeFileName"));
	GenerateChoices();

	//-- init choices --
	for (int i = 0; i < choiceTable.cur_sz; i ++)
	{
		pChoice cho = choiceTable.arr[i];
		cho->init();
	}

	//--
	eliminateDeadends();

	//--
	//saveGraphForVis((char*)"afterDL.gdl");

	//-- create compact graph representation --
	createCompactNodeArray(nodeArr, nodeTable, edgeTable);

	

	//-- find paths --
	multiThreadScheduler(FIND_PATHS);


	//-- iterate: one iteration is already done above! --
	int num_iter = conf.get_int((char*)"NumIterations");

	for (int i = 2; i <= num_iter; i++)
	{
		printf("\n\n --- Iteration %d ---", i);
		Choice::propagateAllWeights();	
		multiThreadScheduler(RECOMPUTE_WEIGHTS);
	}

	
	//-- output results --
	outputResults();
	

	//printf("\n Hit a key to terminate!");
	//getchar();

	delete cs_model;

	return 0;
}


