//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <math.h>

#include "../data/FullEdge.hpp"
#include "../util/Hash.hpp"

#include "PCM2.hpp"

extern Hash<pFullEdge> edgeTable;

//----------------------
PCM2::PCM2() : Model()
{
	;
}


//----------------------
void PCM2::getPathWeight(int *path_fnodes, int *path_fedges, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed)
{
	is_fixed = false;
	fix_w = 0;
	dyn_w = 1;

	for (int i = 0; i < path_sz; i++)
	{
		pFullEdge fedge = edgeTable.get(path_fedges[i]);
		dyn_w *= fedge->w;
	}
}
	
//----------------------
void PCM2::print()
{
	printf("Path Count2 CS Model [PCM2]");
}

