//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "../data/FullEdge.hpp"
#include "../data/FullNode.hpp"
#include "../util/Hash.hpp"

#include "WM.hpp"

extern Hash<pFullEdge> edgeTable;
extern Hash<pFullNode> nodeTable; 
extern int gChoiceNodeT;

//----------------------
WM::WM() : Model()
{
	;
}


//----------------------
void WM::getPathWeight(int *path_fnodes, int *path_fedges, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed)
{
	double cs = 1.0;
	is_fixed = true;
	//is_fixed = false;


	if (path_sz <= 0)
	{
		fix_w = 1;
		dyn_w = 0;
		return;
	}

	//-- first edge: just its weight w --
	pFullEdge fedge = edgeTable.get(path_fedges[0]);
	cs = fedge->w;

	//-- subseq edges: proportional contribution w/sum--
	for (int i = 1; i < path_sz; i++)
	{
		pFullNode fnode = nodeTable.get(path_fnodes[i]);

		//-- is path fixed? (simplified) --
		if (fnode->type == gChoiceNodeT)
			is_fixed = false;

		//-- get sum of edge weights --
		double sum = 0;
		for (int j = 0; j < fnode->edges.cur_sz; j++)
		{
			fedge = edgeTable.get(fnode->edges.arr[j]);
			sum += fedge->w;
		}

		if (sum == 0)
		{
			cs = 0;
			break;
		}

		fedge = edgeTable.get(path_fedges[i]);
		cs = cs * (fedge->w / sum);
	}

	if (is_fixed) {	fix_w = cs; dyn_w = 0; }
	else		  {	fix_w = 0; dyn_w = cs; }
}
	
//----------------------
void WM::print()
{
	printf("Simplified Weight-based Model [WM]");
}

