//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <memory.h>

#include "../data/FullNode.hpp"
#include "../util/Hash.hpp"

#include "GrdNBH.hpp"

extern int gAPMaxNodes;
extern int gNBHMaxNodes;
extern Hash<pFullNode> nodeTable;


//--
GrdNBH::GrdNBH()
{
	int max_nds = nodeTable.num_elem + 10;
	int max_els = __max(gAPMaxNodes, gNBHMaxNodes) + 10; 

	map			= new NbhEl[max_nds];
	pathStore	= new PathEl[max_els];
	pq			= new Heap<PQEl>(max_els);

	//--
	if (map == NULL || pathStore == NULL || pq == NULL)
	{
		printf("\n GrdNBH::GrdNBH(int max_nodes): Cannot reserve memory.");
		exit(-1);
	}

	//-- init map --
	for (int i = 0; i < max_nds; i ++ )
		map[i].center = -1;	
}


//--
GrdNBH::~GrdNBH()
{
	delete map;
	delete pathStore;
	delete pq;
}


//-- 
void GrdNBH::build(pNode center, pNode nodeArr, int R, int N_exp)
{
	//-- init basic stuff, before doing processing --
	this->center = center;
	center_id = (int)(center - nodeArr);
	map[center_id].center = center_id;
	map[center_id].dist = 0;

	//-- check if center is actually connected to the rest of the graph --
	if (center->num_edges == 0)
	{
		this->R = 1000000; // a large number 
		this->R_act = 0;
		return;
	}

	this->R = R;
	this->R_act = R;



	//-- put center as the first element in pathStore --
	pPathEl path = &pathStore[0];
	path->node   = center;
	path->prv_el = NULL;
	path->len	 = 0;
	pathStore_sz = 1;
	

	//-- put center as the first task in PQ --
	pq->clean();
	PQEl tmp;
	tmp.key		= 1;
	tmp.path	= path;
	pq->put(tmp);


	//-- main loop --
	while (pq->isNotEmpty() && N_exp > 0)
	{
		//-- get the best option to work on -- 
		PQEl pq_el = pq->get();
		double key = pq_el.key;
		pPathEl path = pq_el.path;
		pNode node = path->node;


		//-- explore that option: all its neighors are the best --
		for (int i = 0; i < node->num_edges && N_exp > 0; i ++)
		{
			pNode next_node = node->edges[i];

			//-- check if there is a cheaper way to get to next_node --
			int next_node_id = (int)(next_node - nodeArr);
			char new_path_len = path->len + 1;
		
			if (map[next_node_id].center == center_id)
			{
				if (map[next_node_id].dist <= new_path_len)
					continue;
			}
			else
			{
				map[next_node_id].center = center_id;
			}

			//-- update map --
			map[next_node_id].dist = new_path_len;

			if (new_path_len >= R)
				continue;

		
			//-- create a new path --
			pPathEl newPath = &pathStore[pathStore_sz];
			newPath->node   = next_node;
			newPath->prv_el = path;
			newPath->len    = new_path_len;
			pathStore_sz ++;

		
			//-- put a new task in the queue --
			PQEl tmp;
			tmp.key		= key / (next_node->num_edges << 1); 
			tmp.path	= newPath;
			pq->put(tmp);
			N_exp --;
		}
	}

	//-- quit from main loop --

	/* if (pq->isEmpty() && N_exp > 0) //July 21, 2006 this is wrong, won't work for large N_exp
	{
		//-- Priority queue is empty, but N_exp > 0, thus R=infty --
		this->R = 1000000; // not clear if helps to speed up		
	}*/

}
