//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#ifndef GRDNBH_HPP
#define GRDNBH_HPP


#include "../data/Node.hpp"
#include "../util/Heap.hpp"

//--
class NbhEl
{
public:
	int center;
	int dist;
};


//--
class PathEl
{
public:
	pNode node;
	PathEl* prv_el;
	char len;
};

typedef PathEl* pPathEl;


//--
class PQEl
{
public:
	double	key;		// priority queue key (cost of scanning edges)	
	pPathEl path;		// pointer to the path in the path storage
};


//--
class GrdNBH
{
public:
	Node* center;
	int R;				// radius that was requested
	int R_act;			// actual_radius <= radius
	NbhEl* map;			// map of distances to center	

	//-- auxilary --
	int center_id;
	pPathEl pathStore;
	int pathStore_sz;
	Heap<PQEl> *pq;


	//-- constructor --
	GrdNBH();
	~GrdNBH();

	GrdNBH(Node* center, int R);

	void build(pNode center, pNode nodeArr, int R, int N_exp);
};

typedef GrdNBH *pGrdNBH;


#endif
