//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>

#include "../data/Choice.hpp"
#include "../nbh/GrdNBH.hpp"



//-------------
int grdAllPathsNBH(pNode srcNode, pGrdNBH nbh, int L, int N_exp, pNode nodeArr, pChoice cho, int opt_no)
{
	//printf("\n z1");

	pNode dstNode = nbh->center;

	//-- check that "src != dst" and srcNode is connected to something else --
	if (srcNode == dstNode || srcNode->num_edges == 0 || dstNode->num_edges == 0)
	{
		return 0;
	}

	pPathEl pathStore = nbh->pathStore;
	Heap<PQEl> *pq = nbh->pq;
	int R = nbh->R;
	NbhEl* map = nbh->map;
	int center_id = nbh->center_id;


	//-- put srcNode as the first element in pathStore --
	pPathEl path = &pathStore[0];
	path->node   = srcNode;
	path->prv_el = NULL;
	int pathStore_sz = 1;

	//printf("\n src_node=%d", srcNode->fnode->id);
	


	//-- put srcNode as the first task in PQ --
	pq->clean();
	PQEl tmp;
	tmp.key		= 1;
	tmp.path	= path;
	pq->put(tmp);

	//printf("\n z2");

	//-- main loop --
	while (pq->isNotEmpty() && N_exp > 0)
	{
		//printf("\n z3");

		//-- get the best option to work on -- 
		PQEl pq_el = pq->get();
		double key = pq_el.key;
		pPathEl path = pq_el.path;
		pNode node = path->node;

		/*printf("\n ");

		for (pPathEl tmp = path; tmp != NULL; tmp = tmp->prv_el)
		{
			printf("nd=%d,len=%d;",tmp->node->fnode->id, tmp->len);
		}

		if (node->fnode->id == 103854)
		{
			printf("\n ***qqq1***");
			printf("\n path_len=%d, src=%d, dst=%d", 
					path->len, srcNode->fnode->id, dstNode->fnode->id);
			node->print();
			getchar();
		}*/


		//-- explore that option: all its neighors are the best --
		for (int i = 0; i < node->num_edges && N_exp > 0; i ++)
		{
			//printf("\n z4");

			pNode next_node = node->edges[i];

			/*if (next_node->fnode->id == 103854)
			{
				printf("\n ***qqq2***");
				printf("\n path_len=%d, i=%d, src=%d, dst=%d", 
					path->len, i, srcNode->fnode->id, dstNode->fnode->id);
				
				node->print();
				//printf("\n");
				next_node->print();
				getchar();
			}*/


			//-- handle destination --
			if (next_node == dstNode)
			{
				//printf("\n A path is found.");
				//getchar();
				/*printf("\n ************");
				for (pPathEl tmp = path; tmp != NULL; tmp = tmp->prv_el)
				{
					printf("nd=%d,len=%d;",tmp->node->fnode->id, tmp->len);
				}

				printf("\n z4.3");*/
				cho->addPath(path, dstNode, opt_no);
				//printf("\n z4.4");
				continue;
			}
			//printf("\n z4.5");

			//-- check if the next_node is already on the path --
			for (pPathEl subPath = path; subPath != NULL; subPath = subPath->prv_el)
			{
				if (next_node == subPath->node)
					goto next_i;
			}

			//printf("\n z5");


			//-- check if should be inside NBH --
			{
                char new_path_len = path->len + 1;
                if (new_path_len + R >= L)
                {
                    int next_node_id = (int)(next_node - nodeArr);
                    
                    if (map[next_node_id].center != center_id)
                        continue;
                    
                    if (new_path_len + map[next_node_id].dist > L)
                        continue;
                }
                
                
                //printf("\n z6");
                
                //-- create a new path --
                pPathEl newPath = &pathStore[pathStore_sz];
                newPath->node   = next_node;
                newPath->prv_el = path;
                newPath->len    = new_path_len;
                pathStore_sz ++;
                
                //-- put a new task in the queue --
                PQEl tmp;
                tmp.key	 = key / (next_node->num_edges << 1);  
                tmp.path = newPath;
                pq->put(tmp);
                N_exp --;
            }

next_i:
			;
		}
	}

	return 0;
}


