//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdlib.h>

#define UNIX
//#define WINDOWS

#ifdef UNIX
#include <pthread.h>
#endif

#include "../nbh/GrdNBH.hpp" 
#include "../util/Config.hpp"
#include "../util/Util.hpp"

#include "../const.hpp"



extern Config conf;



//-- threads --
pthread_mutex_t mutex1 = PTHREAD_MUTEX_INITIALIZER;
void *thread_function( void *ptr );

class ThreadParam
{
public:
	int goal;		//(a) find paths (b) resolve choices
	int thread_id;
	int fr_item;
	int to_item;
	int *last_item;
	int *next_item;
	int num_threads;
};


//--
void multiThreadScheduler(int goal)
{
	Timer timer;
	timer.start();

	int last_item;
	int next_item;

	
	int num_threads = conf.get_int((char*)"NumberOfThreads");
	num_threads = __min(num_threads, choiceTable.cur_sz);

	if (num_threads == 0)
		return;


	printf("\n Starting %d thread(s) ... ", num_threads);

#ifdef UNIX
	pthread_t *thread = new pthread_t[num_threads];
#endif

	ThreadParam *param = new ThreadParam[num_threads];

	int chunk_sz = __max( choiceTable.cur_sz / (num_threads * 25), 1);

	pthread_mutex_lock( &mutex1 );

	for (int i = 0; i < num_threads; i ++)
	{
		param[i].goal		 = goal; 
		param[i].thread_id	 = i;
		param[i].fr_item	 = i * chunk_sz;
		param[i].to_item	 = param[i].fr_item + chunk_sz - 1;
		param[i].last_item	 = &last_item;
		param[i].next_item   = &next_item;
		param[i].num_threads = num_threads;
	
#ifdef UNIX
		pthread_create( &thread[i], NULL, thread_function, (void*) &param[i]);
#endif

#ifdef WINDOWS
		thread_function(&param[i]);
#endif
		
	}

	last_item = choiceTable.cur_sz - 1;
	next_item = param[num_threads - 1].to_item + 1;

	pthread_mutex_unlock( &mutex1 );

#ifdef UNIX
	//-- wait for threads to complete --
	for (int i = 0; i < num_threads; i ++)
		pthread_join( thread[i], NULL);

	delete thread; //qqq
#endif
	delete param; //qqq


	printf("\n\n Done with threads in %.3f secs", timer.getTime());
}


//--
void *thread_function( void *ptr )
{
	//-- Parse params --
	ThreadParam *param;
	param = (ThreadParam *) ptr;
	int goal		= param->goal; 
	int thread_id	= param->thread_id;
	int fr_item		= param->fr_item;
	int to_item		= param->to_item;
	int *last_item	= param->last_item;
	int *next_item	= param->next_item;
	int num_threads = param->num_threads;

	//--
	printf("Thread %d \n", thread_id);

	//-- init NBH --
	pGrdNBH nbh;

	if (goal == FIND_PATHS) nbh = new GrdNBH();
	else					nbh = NULL;

	//pNode dstNode;

	Timer timer;
	timer.start();
	
	int count = 0;

next_batch:

	for (int j = fr_item; j <= to_item; j ++)
	{
		double time = timer.getTime() + 0.0000001;

		if (++count % 50 == 0) 
			printf("\n Th[%d]: count=%d (~%.2f) in %.3f secs (%.2f cho/secs): %.2f done", 
			thread_id, count, double(count) * num_threads / *last_item, time, count / time, *next_item / double(*last_item));

		pChoice fullcho = choiceTable.arr[j];

		//printf("\n q1");
		if (goal == FIND_PATHS) fullcho->findPaths(*nbh);
		else					fullcho->recomputeWeights();
		//printf("\n q2");
	}	


	//-- decide what to do next --
	pthread_mutex_lock( &mutex1 );

	//-- is there anything else to do? --
	int items_left = *last_item - *next_item + 1;
	if (items_left <= 0)
	{
		pthread_mutex_unlock( &mutex1 );
		return NULL;
	}

	//-- yes, some items still need to be processed --
	int batch_sz;
	double speed;

	double time = timer.getTime();
	
	if (time > 0) speed = count / time;
	else          speed = 0;

	//printf("speed=%d ", speed);

	//-- determine batch_sz --
	if (time > 1 && speed > 0) 
	{
		double time_left1 = items_left / speed;

		//-- see if can finish the rest, alone, under 1 sec --
		if      (time_left1 < 1          ) batch_sz = *last_item - *next_item + 1;
		else if (time_left1 < num_threads) batch_sz = __max((int)(speed * 1), 1); // for 1 sec
		else
		{
			double time_left = time_left1 / num_threads;
			double work_time = __min(time_left / 5, 20);
			work_time = __max(work_time, 1);
			batch_sz = __max((int)(speed * work_time), 1);
		}
	}
	else
	{
		batch_sz = __max((int)(items_left / (num_threads * 5)), 1);
	}

	fr_item = *next_item;
	to_item = __min(*next_item + batch_sz - 1, *last_item);
	*next_item = to_item + 1;
	
	pthread_mutex_unlock( &mutex1 );
	
	printf("##Thread %d: [%d,%d]", thread_id, fr_item, to_item);

	goto next_batch;
}

