//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "../data/Node.hpp"

#include "Timer.hpp"
#include "Util.hpp"

#include "../const.hpp"


void createCompactNodeArray(pNode &nodeArr, Hash<pFullNode> &nodeTable, Hash<pFullEdge> &edgeTable)
{
	Timer timer;
	timer.start();
	printf("\n Creating compact graph representation ... ");


	nodeArr = new Node[nodeTable.num_elem];
	int node_id = 0;
	int total_num_edges = 0;

	//printf("\n q1");

	//-- 1st loop: Map fnodes and cnodes --
	for (int i = 0; i < nodeTable.num_bucket; i++)
	{
		if (node_id > nodeTable.num_elem)
			break;

		for (int j = 0; j < nodeTable.bucket[i].cur_sz; j++)
		{
			pFullNode fnode = nodeTable.bucket[i].arr[j].val;

			pNode cnode = &nodeArr[node_id];
			fnode->cnode = cnode;
			cnode->fnode = fnode;
			node_id ++;
			total_num_edges += fnode->edges.cur_sz;
		}
	}

	
	//-- 2nd loop: Handle cnode edges --
	for (int i = 0; i < nodeTable.num_elem; i++)
	{
		pNode cnode = &nodeArr[i];
		pFullNode fnode = cnode->fnode;

		//-- determing the number of fnode's distinct nieghbors --
		pNode tmp_arr[10000];
		int tmp_i = 0;

		for (int k = 0; k < fnode->edges.cur_sz; k ++)
		{
			//printf("\n q4 k=%d",k);

			int edge_id = fnode->edges.arr[k];
			pFullEdge fedge = edgeTable.get(edge_id);

			//printf("\n q5");

			//-- get neighbor --
			int nieghbor;
			if (fedge->fnode_id1 == fnode->id) nieghbor = fedge->fnode_id2;
			else							   nieghbor = fedge->fnode_id1;

			//printf("\n q5.1");

			pFullNode nefNode = nodeTable.get(nieghbor);
			if (nefNode == NULL)
			{
				printf("\n createCompactNodeArray(): Critical error.");
				exit(-1);
			}
			pNode necNode = nefNode->cnode;

			if (necNode == cnode)
			{
				printf("\n compactArr(): Error.");
				getchar();
			}

			//printf("\n q6");

			//-- see if we know about necNode already --
			for (int l = 0; l < tmp_i; l++)
			{
				if (tmp_arr[l] == necNode)
					goto nextNode;
			}

			//-- no, necNode is new --
			tmp_arr[tmp_i] = necNode;
			tmp_i ++;
nextNode: ;
		}


		//-- reflect distinct neighbors --
		cnode->num_edges = (short)tmp_i;

		if (tmp_i != 0) 
		{
			cnode->edges = new pNode[tmp_i];
			memcpy(cnode->edges, tmp_arr, tmp_i * sizeof(pNode));
		}
		else
		{
			cnode->edges = NULL;
		}

	}

	printf("%.3f secs", timer.getTime());
}

