//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "../data/FullNode.hpp"
#include "../data/FullEdge.hpp"

#include "../model/Model.hpp"

#include "Util.hpp"
#include "../const.hpp"


extern pModel cs_model;
extern HashStr<int> fnid2feid;

void computeSinglePathWeight(int *path_nodes, int *path_edges, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed);

//-------------------------------------------------
void computePathWeight(int *path_fnodes, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed)
{
	//printf("\n y1");

	//-- path = 0-1-2-3; len = 3 --
	int path_fedges[100];
	int parl_fedges[20][1000];	// assuming path_sz < 20, paral edges < 100 
	int fedge_count[20];			// the number of || edges
	int tmp_count[20];

	// There can be multiple paths going via the same edges:
	// if there are parallel edges. Generate all possible
	// paths and pass them to a particular CS model for weighing.


	//-- fill out parl_edges & edge_count --
	for (int i = 0; i < path_sz; i++)
	{
		unsigned int node_id1 = path_fnodes[i];
		unsigned int node_id2 = path_fnodes[i+1];

		/*if (path_fnodes[0] == 73308) 
			printf("\n y nid1=%d, nid2=%d", node_id1, node_id2);*/

		//-- find edges that connect nodes 1 & 2 --
		int a[2];
		unsigned char* p = (unsigned char*)&a[0];

		if (node_id1 < node_id2){ a[0] = node_id1; a[1] = node_id2; }
		else					{ a[0] = node_id2; a[1] = node_id1; }

		fedge_count[i] = fnid2feid.getK(p, sizeof(int) * 2, parl_fedges[i]);

		/*if (path_fnodes[0] == 73308) 
			printf("\n y fc=%d", fedge_count[i]);*/

		tmp_count[i]  = 0;
	}

	fix_w = 0;
	dyn_w = 0;
	is_fixed = true;

	//printf("\n y2");

	//-- use parl_edges & edge_count to generate paths --
	for (;;)
	{
		for (int i = 0; i < path_sz; i++)
		{
			path_fedges[i] = parl_fedges[i][tmp_count[i]];
		}

		double fix_w2;
		double dyn_w2;
		bool is_fixed2;

		//printf("\n y2.5");
		cs_model->getPathWeight(path_fnodes, path_fedges, path_sz, fix_w2, dyn_w2, is_fixed2);
		//printf("\n y2.6");

		fix_w += fix_w2;
		dyn_w += dyn_w2;
		if (!is_fixed2) is_fixed = false;

		//printf("\n y3");

		//-- increment tmp_count --
		for (int i = path_sz - 1; ; i--)
		{
			//-- can we increment i_th elem? --
			if (tmp_count[i] >= fedge_count[i] - 1)
			{
				//-- no, we cannot inc --
				if (i <= 0) return;
			}
			else
			{
				//-- yes, we can inc --
				tmp_count[i] ++;

				for (int j = i + 1; j < path_sz; j ++)
					tmp_count[j] = 0;

				break;
			}
		}
	}
}

//-------------------------------------------------
/*void computeSinglePathWeight(unsigned int *path_nodes, int *path_edges, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed)
{
	is_fixed = false;
}*/
