//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Config.hpp"


//--
Config::Config(const char* file_name)
{
	FILE *fr; 

	fr = fopen(file_name, "r"); 
	if (fr == NULL)
	{
		printf("\n Config::Config(): Cannot open file %s", file_name); 
		exit(-1); 
	}


	//--- get file size --- 
	fseek(fr, 0, SEEK_END); 
	buf_sz = (int)ftell(fr);
	fseek(fr, 0, SEEK_SET); 

	//--- allocate space --- 
	buf = new char[buf_sz + 1];  
	if (buf == NULL) 
	{ 
		printf("\n Config::Config(): Cannot allocate memory."); 
		exit(-1); 
	} 

	//--- read ---
	fread(buf, sizeof(char), buf_sz, fr); 
	fclose(fr);

	//-- make buf a zero-terminated string --
	buf[buf_sz] = 0;
}

//--
Config::~Config()
{
	delete buf;
}

//-- 
int Config::get_int(char *param)
{
	char *str = get_str(param);
	
	int i = atoi(str);
	delete str;

	return i;
}


//--
double Config::get_double(char *param)
{
	char *str = get_str(param);
	
	double x = atof(str);
	delete str;

	return x;
}




//-- 
char* Config::get_str(char *param)
{
	int par_len = (int)strlen(param);
	char* query = new char[par_len + 3];
	
	query[0          ] = '<';
	strcpy(&query[1], param);
	query[par_len + 1] = '>';
	query[par_len + 2] = 0;
	
	char *par_loc = strstr(buf, query);
	delete query;

	if (par_loc == NULL)
	{
		printf("\n Config::get(): Parameter '%s' not found.", param);
		exit(-1);
	}

	//-- extract string --
	par_loc = &par_loc[par_len + 2];
	char* par_end = par_loc;

	while ( par_end[0] != '<' && par_end[0] != 0)
		par_end ++;

	if (par_loc == par_end)
	{
		printf("\n Config::get(): Parameter '%s' is empty.", param);
		exit(-1);
	}


	char tmp_c = par_end[0];
	par_end[0] = 0;

	char *res = strdup(par_loc);
	par_end[0] = tmp_c;

	return res;	
}



