//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "../data/FullNode.hpp"
#include "../data/FullEdge.hpp"
#include "../util/Fifo.hpp"
#include "../util/Timer.hpp"

#include "../const.hpp"

extern int gChoiceNodeT;

void eliminateDeadends()
{
	Timer timer;
	timer.start();
	printf("\n Eliminating Deadends ... ");


	Fifo<pFullNode> candidates;

	int node_id = 0;

	//-- populate candidate list --
	for (int i = 0; i < nodeTable.num_bucket; i++)
	{
		if (node_id > nodeTable.num_elem)
			break;

		for (int j = 0; j < nodeTable.bucket[i].cur_sz; j++)
		{
			pFullNode fnode = nodeTable.bucket[i].arr[j].val;
			candidates.insert(fnode);
			node_id ++;
		}
	}

	int node_count = 0;
	int edge_count = 0;


	//-- check nodes one by one for Deadends --
	while(!candidates.isEmpty())
	{
		pFullNode fnode = candidates.get();

		//-- was it already removed?-- 
		if (nodeTable.get(fnode->id) == NULL)
			continue;

		//-- node exists, check the degree --
		if (fnode->edges.cur_sz == 0)
		{
			node_count ++;
			delete fnode;
			continue;
		}

		//-- deadend? --
		if (fnode->edges.cur_sz > 1) 
			continue; //no

		//-- yes, but if connected to choice, then must keep --

		//-- get the only edge --
		pFullEdge fedge = edgeTable.get(fnode->edges.arr[0]);

		if (fedge == NULL)
		{
			printf("\n eliminateDeadends(): edge(%d) in node(%d) does not exist", fnode->edges.arr[0], fnode->id);
			exit(-1);
		}


		//-- is it connected to a choice? --
		pFullNode fnode2;

		if (fedge->fnode_id1 == fnode->id)	fnode2 = nodeTable.get(fedge->fnode_id2);
		else								fnode2 = nodeTable.get(fedge->fnode_id1);	

		if (fnode2 == NULL)
		{
			printf("\n eliminateDeadends(): fnode(%d)", fnode->id);
			exit(-1);
		}
		
		if (fnode2->type == gChoiceNodeT)
			continue; //yes

		//-- no --
		candidates.insert(fnode2);

		//printf("\n %d: deleting node(%d)", count, fnode->id);

		node_count ++;
		edge_count ++;

		delete fnode;
	}

	printf("(%d nodes, %d edges) in %.3f secs", node_count, edge_count, timer.getTime());

}

