//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

// MVCI by Dmitri V. Kalashnikov 2002-08-24

#ifndef Fifo_CPP
#define Fifo_CPP

#include <stdio.h> 
#include <stdlib.h> 
 
#include "Fifo.hpp" 

//------------------------- 
template <class DATA>
Fifo<DATA>::Fifo() 
{ 
	this->head = NULL; 
	this->tail = NULL;
}

//------------------------- 
template <class DATA>
Fifo<DATA>::~Fifo() 
{ 
	clean();
} 


//------------------------- 
template <class DATA>
void Fifo<DATA>::clean() 
{ 
	while( get() != NULL)
		;

	head = tail = NULL;
} 
 
//------------------------- 
template <class DATA>
bool Fifo<DATA>::isEmpty()
{
	return head == NULL;
} 

 
//------------------------- 
template <class DATA>
void Fifo<DATA>::insert(DATA data) 
{ 
	//-- add to tail --
	if (tail == NULL) // list is empty
	{
		head = tail = new FifoNode<DATA>(data, NULL, NULL);
		return;
	}

	//-- list is not empty --
	tail->next = new FifoNode<DATA>(data, tail, NULL);
	tail = tail->next;
}
 

//------------------------- 
template <class DATA>
DATA Fifo<DATA>::get() 
{ 
	// Get from head

	//-- check if FIFO is empty --
	if (head == NULL)
		return NULL;

	//-- FIFO is not empty --
	DATA data = head->data;

	FifoNode<DATA> *tmp = head;
	head = head->next;

	if (head == NULL)
		tail = NULL;

	delete tmp;

	return data;
} 

//------------------------- 
template <class DATA>
DATA Fifo<DATA>::peek() 
{ 
	if (head == NULL)
		return NULL;

	return head->data;
} 
 
//-------------------------  
template <class DATA>
void Fifo<DATA>::remove(DATA data)  
{  
	printf("\n Fifo<DATA>::remove(DATA data)  is not emplented");
	getchar();
	exit(-1);


	//-- handle empty Fifo -- 
	if ( isEmpty() ) 
	{ 
		printf("\nFifo::remove() - attempt to delete from empty Fifo"); 
		getchar(); 
 
		return; 
	} 
		 
	//-- handle case when data is first elem -- 
	if (head->data == data) 
	{ 
		FifoNode<DATA> *tmp = head; 
		head = tmp->next; 
 
		delete tmp; 
		return; 
	} 
 
	//-- data is not the first elem -- 
	FifoNode<DATA> *prev_node = head; 
 
	for (FifoNode<DATA> *cur_node = head->next; cur_node != NULL; cur_node = cur_node->next) 
	{ 
		if (cur_node->data == data) 
		{ 
			//-- remove cur_node -- 
			prev_node->next = cur_node->next; 
 
			delete cur_node; 
 
			return; 
		} 
 
		prev_node = cur_node; 
	} 
 
	printf("\nFifo::remove() - specified queue is not found in Fifo"); 
	getchar(); 
	 
	return; 
} 
 
//------------------------- 
template <class DATA>
void Fifo<DATA>::print() 
{ 
	for (FifoNode<DATA> *pnode = head; pnode != NULL; pnode = pnode->next) 
	{ 
		pnode->data->print(); 
	} 
}


//------------------------- 
template <class DATA>
int Fifo<DATA>::getSize() 
{
	int i = 0;

	for (FifoNode<DATA> *pnode = head; pnode != NULL; pnode = pnode->next) 
	{ 
		i ++;
	} 

	return i;
}
#endif

