//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "Config.hpp"

#include "Rand.hpp"
#include "Util.hpp"


extern int gChoiceNodeT;
extern Config conf;
extern Hash<pFullNode> nodeTable; 
extern Hash<pFullEdge> edgeTable;
extern DynArray<pChoice> choiceTable;


void populateOptNodes(int *opt_node_arr, int &node_arr_sz);
void populateChoEdges(int *cho_edge_arr, int &edge_arr_sz);
void replaceEdgeWithCho(int fedge_id, int *opt_node_arr, int node_arr_sz);

//---
void GenerateChoices(void)
{
	//-- how many to generate --
	static double frac = conf.get_double((char*)"FracUncRef");
	if (frac == 0) return;

	//--
	Timer timer;
	timer.start();
	printf("\n Generating choices ... ");

	//-- prepare to generate choices --
	int *opt_node_arr = new int[nodeTable.num_elem];
	int *cho_edge_arr = new int[edgeTable.num_elem];
	int node_arr_sz;
	int edge_arr_sz;


	//--
	populateOptNodes(opt_node_arr, node_arr_sz);
	populateChoEdges(cho_edge_arr, edge_arr_sz);


	//-- choose edges to be replaced randomly --
	int j = edge_arr_sz - 1;

	for (int i = 0; i < edge_arr_sz * frac; i ++)
	{
		int k = (int)(Rand::rnd() * (j + 1)); //[0,j]

		//-- swap a[j] and a[k] --
		int tmp = cho_edge_arr[j];
		cho_edge_arr[j] = cho_edge_arr[k];
		cho_edge_arr[k] = tmp;

		j --;
	}

	//-- replace edges with choices
	for (int i = j + 1; i < edge_arr_sz; i ++)
		replaceEdgeWithCho(cho_edge_arr[i], opt_node_arr, node_arr_sz);

	//--
	delete opt_node_arr;
	delete cho_edge_arr;

	printf("(total %d) in %.3f secs", choiceTable.cur_sz, timer.getTime());
}


//---------
void replaceEdgeWithCho(int fedge_id, int *opt_node_arr, int node_arr_sz)
{
	static int GENERATE_ID = -1;
	static int CntNodeType = conf.get_int((char*)"CntNodeType");

	pFullEdge fedge = edgeTable.get(fedge_id);
	pFullNode cnt_fnode = nodeTable.get(fedge->fnode_id1);
	pFullNode ans_fnode = nodeTable.get(fedge->fnode_id2);

	if (cnt_fnode->type != CntNodeType)
	{
		pFullNode tmp = cnt_fnode;
		cnt_fnode = ans_fnode;
		ans_fnode = tmp;
	}

	delete fedge;


	//-- generate choice node --
	pChoice cho = new Choice(GENERATE_ID, gChoiceNodeT, (char*)"cho", cnt_fnode->id, ans_fnode->id, true);


	//-- generate opt-cho edge --
	int new_edge_type = 1000 + cnt_fnode->type;
	new FullEdge(GENERATE_ID, cnt_fnode->id, cho->id, new_edge_type, (char*)"opt-cho", true);


	//-- generate cho-ans edge --
	new_edge_type = 1000 + ans_fnode->type;
	new FullEdge(GENERATE_ID, cho->id, ans_fnode->id, new_edge_type, (char*)"cho-ans", true);


	//-- choose the number of option to generate --
	static char* s = conf.get_str((char*)"OptGenMode");
	int num_extra_opt;

	if (strcmp(s, "pmf") == 0)	num_extra_opt = Rand::rndIntTruncNormal(2, 3, 1, 19);
	else 						num_extra_opt = atoi(s) - 1;
	
	
	//-- generate extra options, m.b. distinct! --
	for (int i = 0; i < num_extra_opt; i++)
	{
		int prev_opt[1000];

new_opt_id:
		int opt_id = opt_node_arr[(int)(Rand::rnd() * node_arr_sz)];
		
		for (int j = 0; j < i; j++)
			if (opt_id == prev_opt[j])
				goto new_opt_id;

		prev_opt[i] = opt_id;

		new FullEdge(GENERATE_ID, cho->id, opt_id, new_edge_type, (char*)"cho-opt", true);
	}
}


//---------
void populateOptNodes(int *opt_node_arr, int &node_arr_sz)
{
	int OptNodeType = conf.get_int((char*)"OptNodeType");
	node_arr_sz = 0;

	for (int i = 0; i < nodeTable.num_bucket; i++)
	{
		if (node_arr_sz > nodeTable.num_elem)
			break;

		for (int j = 0; j < nodeTable.bucket[i].cur_sz; j++)
		{
			pFullNode fnode = nodeTable.bucket[i].arr[j].val;

			if (fnode->type == OptNodeType)
			{
				opt_node_arr[node_arr_sz] = fnode->id;
				node_arr_sz ++;
			}
		}
	}
}


//---------
void populateChoEdges(int *cho_edge_arr, int &edge_arr_sz)
{
	int ChoEdgeType = conf.get_int((char*)"ChoEdgeType");
	edge_arr_sz = 0;

	for (int i = 0; i < edgeTable.num_bucket; i++)
	{
		if (edge_arr_sz > edgeTable.num_elem)
			break;

		for (int j = 0; j < edgeTable.bucket[i].cur_sz; j++)
		{
			pFullEdge fedge = edgeTable.bucket[i].arr[j].val;

			if (fedge->type == ChoEdgeType)
			{
				cho_edge_arr[edge_arr_sz] = fedge->id;
				edge_arr_sz ++;
			}
		}
	}
}
