//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#ifndef HASH_CPP
#define HASH_CPP

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Hash.hpp"

//-------------------------
template <class DATA>
Hash<DATA>::Hash(int num_bucket)
{
	bucket = new DynArray<HashEl <DATA> >[num_bucket];

	if (bucket == NULL)
	{
		printf("\n Hash<DATA>::Hash(int num_bucket): Cannot reserve memory.");
		exit(-1);
	}

	this->num_bucket = num_bucket;
	this->num_elem = 0;
}

//-------------------------
template <class DATA>
Hash<DATA>::~Hash()
{
    /* Fix the below issue with delete
     it should be uncommented, but has been commented out due to the crash it is causing when the RelDC quits*/
	//delete bucket;
}
 
//-------------------------
template <class DATA>
void Hash<DATA>::insert(unsigned int key, DATA val)
{
	//-- determine bucket --
	unsigned int hashvalue;	
	unsigned char *pkey  = (unsigned char *)&key;
	unsigned char *phash = (unsigned char *)&hashvalue;

	unsigned int more3bits = (key >> 3) & 7; //0111

	phash[0] = pkey[0] ^ pkey[1];
	phash[1] = pkey[1] ^ pkey[2];
	phash[2] = pkey[2] ^ pkey[3];
	phash[3] = pkey[3] ^ pkey[0];

	hashvalue = (hashvalue ^ more3bits) % num_bucket;

	HashEl<DATA> hashEl;

	hashEl.key = key;
	hashEl.val = val;

	bucket[hashvalue].insert(hashEl);
	num_elem ++; // for statistics, remove for speedup
}


//-------------------------
template <class DATA>
DATA Hash<DATA>::get(unsigned int key)
{
	//-- determine bucket --
	unsigned int hashvalue;	
	unsigned char *pkey  = (unsigned char *)&key;
	unsigned char *phash = (unsigned char *)&hashvalue;

	unsigned int more3bits = (key >> 3) & 7; //0111

	phash[0] = pkey[0] ^ pkey[1];
	phash[1] = pkey[1] ^ pkey[2];
	phash[2] = pkey[2] ^ pkey[3];
	phash[3] = pkey[3] ^ pkey[0];

	hashvalue = (hashvalue ^ more3bits) % num_bucket;


	DynArray< HashEl<DATA> > *pq = &bucket[hashvalue];
	
	for (int i = 0; i < pq->cur_sz; i ++)
	{
		if (pq->arr[i].key == key)
			return pq->arr[i].val;
	}

	return (DATA) 0;
}

//-------------------------
template <class DATA>
void Hash<DATA>::remove(unsigned int key)
{
	//-- determine bucket --
	unsigned int hashvalue;	
	unsigned char *pkey  = (unsigned char *)&key;
	unsigned char *phash = (unsigned char *)&hashvalue;

	unsigned int more3bits = (key >> 3) & 7; //0111

	phash[0] = pkey[0] ^ pkey[1];
	phash[1] = pkey[1] ^ pkey[2];
	phash[2] = pkey[2] ^ pkey[3];
	phash[3] = pkey[3] ^ pkey[0];

	hashvalue = (hashvalue ^ more3bits) % num_bucket;


	DynArray< HashEl<DATA> > *pq = &bucket[hashvalue];
	
	for (int i = 0; i < pq->cur_sz; i ++)
	{
		if (pq->arr[i].key != key)
			continue;
		
		pq->cur_sz --;
		pq->arr[i].key = pq->arr[pq->cur_sz].key;
		pq->arr[i].val = pq->arr[pq->cur_sz].val;

		i--;
		num_elem --; // for statistics, remove for speedup
	}
}


#endif

