#ifndef HASHSTR_CPP
#define HASHSTR_CPP

#include <stdio.h>
//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdlib.h>
#include <string.h>

#include "HashStr.hpp"

//-------------------------
template <class DATA>
HashStr<DATA>::HashStr(int num_bucket)
{
	bucket = new DynArray<HashStrEl <DATA> >[num_bucket];

	if (bucket == NULL)
	{
		printf("\n HashStr<DATA>::HashStr(int num_bucket): Cannot reserve memory.");
		exit(-1);
	}

	this->num_bucket = num_bucket;
	this->num_elem = 0;
}

//-------------------------
template <class DATA>
HashStr<DATA>::~HashStr()
{
    /*** TODO: fix the below delete: it should be there uncommented,
    but currently casuses a crash, so it is commented out ***/
	
    //delete bucket; qqq
}
 
//-------------------------
typedef unsigned char u_char;

template <class DATA>
void HashStr<DATA>::insert(unsigned char *key, unsigned char key_sz, DATA val)
{
	//-- determine bucket --
	unsigned int hashvalue = 0;	
	unsigned char *phash = (unsigned char *)&hashvalue;

	for (int i = 0; i < key_sz; i++)
	{
		unsigned char k  = key[i];
		unsigned char k3 = key[i] >> 3; // cause last three bits might be all 0's...
		phash[i % sizeof(hashvalue)] = phash[i % sizeof(hashvalue)] ^ k ^ k3;
	}

	hashvalue = hashvalue % num_bucket;


	//-- prepare a new hash element --
	HashStrEl<DATA> hashEl;

	hashEl.key    = new u_char[key_sz];
	hashEl.key_sz = key_sz;
	hashEl.val	  = val;
	memcpy(hashEl.key, key, key_sz);


	//-- insert value --
	bucket[hashvalue].insert(hashEl);
	num_elem ++; // for statistics, remove for speedup
}


//-------------------------
template <class DATA>
DATA HashStr<DATA>::get(unsigned char *key, unsigned char key_sz)
{
	//-- determine bucket --
	unsigned int hashvalue = 0;	
	unsigned char *phash = (unsigned char *)&hashvalue;

	for (int i = 0; i < key_sz; i++)
	{
		unsigned char k  = key[i];
		unsigned char k3 = key[i] >> 3; // cause last three bits might be all 0's...
		phash[i % sizeof(hashvalue)] = phash[i % sizeof(hashvalue)] ^ k ^ k3;
	}

	hashvalue = hashvalue % num_bucket;



	//-- find the element --
	DynArray< HashStrEl<DATA> > *pq = &bucket[hashvalue];

	for (int i = 0; i < pq->cur_sz; i ++)
	{
		if (pq->arr[i].key_sz != key_sz)
			continue;


		if (memcmp(pq->arr[i].key, key, key_sz) == 0)
			return pq->arr[i].val;

	}


	return (DATA) 0;
}



//-------------------------
template <class DATA>
int HashStr<DATA>::getK(unsigned char *key, unsigned char key_sz, DATA *val)
{
	//-- determine bucket --
	unsigned int hashvalue = 0;	
	unsigned char *phash = (unsigned char *)&hashvalue;

	for (int i = 0; i < key_sz; i++)
	{
		unsigned char k  = key[i];
		unsigned char k3 = key[i] >> 3; // cause last three bits might be all 0's...
		phash[i % sizeof(hashvalue)] = phash[i % sizeof(hashvalue)] ^ k ^ k3;
	}

	hashvalue = hashvalue % num_bucket;



	//-- find the element --
	DynArray< HashStrEl<DATA> > *pq = &bucket[hashvalue];
	int k = 0;

	for (int i = 0; i < pq->cur_sz; i ++)
	{
		if (pq->arr[i].key_sz != key_sz)
			continue;

		if (memcmp(pq->arr[i].key, key, key_sz) != 0)
			continue;

		val[k] = pq->arr[i].val;
		k ++;
	}

	return k;
}



//-------------------------
template <class DATA>
void HashStr<DATA>::remove(unsigned char *key, unsigned char key_sz, DATA val)
{
	//-- determine bucket --
	unsigned int hashvalue = 0;	
	unsigned char *phash = (unsigned char *)&hashvalue;

	for (int i = 0; i < key_sz; i++)
	{
		unsigned char k  = key[i];
		unsigned char k3 = key[i] >> 3; // cause last three bits might be all 0's...
		phash[i % sizeof(hashvalue)] = phash[i % sizeof(hashvalue)] ^ k ^ k3;
	}

	hashvalue = hashvalue % num_bucket;



	//-- find the element --
	DynArray< HashStrEl<DATA> > *pq = &bucket[hashvalue];
	
	for (int i = 0; i < pq->cur_sz; i ++)
	{
		if (pq->arr[i].key_sz != key_sz)
			continue;

		if (memcmp(pq->arr[i].key, key, key_sz) != 0)
			continue;

		if (pq->arr[i].val != val)
			continue;

		//-- swap cur elem with the last --
		delete pq->arr[i].key;
		pq->cur_sz --;
		pq->arr[i].key    = pq->arr[pq->cur_sz].key;
		pq->arr[i].key_sz = pq->arr[pq->cur_sz].key_sz;
		pq->arr[i].val    = pq->arr[pq->cur_sz].val;

		//-- process the same element again --
		i --;
		num_elem --;// for statistics, remove for speedup
	}

}


#endif

