//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#ifndef HASHSTR_HPP
#define HASHSTR_HPP   
 

#include "DynArray.hpp"

//------------------
template <class DATA>  
class HashStrEl  
{ 
public:
	unsigned char *key;
	DATA val;
	unsigned char key_sz;
};


//------------------
template <class DATA>  
class HashStr  
{  
public: 
	//-- vars -- 
	DynArray< HashStrEl<DATA> > *bucket; 
 
	int num_bucket; 
	int num_elem;	// WARNING! for statistics, remove for speedup.
 
	//-- functions -- 
 	HashStr(int num_bucket = 100000);  
	~HashStr();  
  
	void insert(unsigned char *key, unsigned char key_sz, DATA val);
	DATA get(unsigned char *key, unsigned char key_sz);
	int getK(unsigned char *key, unsigned char key_sz, DATA* val);

	void remove(unsigned char *key, unsigned char key_sz, DATA val);  
 	//bool isEmpty();  
	//void print();  
 
};  
  
//typedef HashStr *pHashStr;  
 
#include "HashStr.cpp" //because of templates 
  
#endif 
