//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#ifndef HEAP_CPP
#define HEAP_CPP

#include <stdio.h>
#include <stdlib.h>
#include "Heap.hpp"

//#define NULL 0

//----------------
template <class DATA>
Heap<DATA>::Heap(int max_array_sz)
{
	array = new DATA[max_array_sz];
	if (array == NULL)
	{
		printf("\nHeap::Heap(): cannot allocate array");
		exit(-1);
	}

	this->max_array_sz = max_array_sz;
	array_sz  = 0;
}

//----------------
template <class DATA>
Heap<DATA>::~Heap()
{
	delete array;
}


//----------------
template <class DATA>
void Heap<DATA>::clean()
{
	array_sz = 0;
}

//----------------
template <class DATA> bool Heap<DATA>::isEmpty()	{ return (array_sz == 0); }  
template <class DATA> bool Heap<DATA>::isNotEmpty()	{ return (array_sz != 0); }  


//----------------
template <class DATA>
void Heap<DATA>::put(DATA data)
{
	int par_node;
	int cur_node;
	bool modified;
	
	cur_node = ROOT_NODE + array_sz;
	
	array[cur_node] = data;
	array_sz ++;
	
	modified = true;
	
	while(modified && (cur_node != ROOT_NODE))
	{
		modified = false;
		par_node = GET_PARENT(cur_node);
		
		if (array[par_node].key < array[cur_node].key)
		{
			//--- swap cur_node <-> par_node ---
			DATA tmp		= array[par_node];
			array[par_node] = array[cur_node];
			array[cur_node] = tmp;
			
			cur_node = par_node;
			modified = true;
		}
	}
	
}

//----------------
template <class DATA>
DATA Heap<DATA>::top()
{
	DATA data;

	//-- check if heap is empty --
	if (array_sz == 0)
	{
		//printf("\nHeap<DATA>::get(): error -- q is empty\n");
		data = (DATA)NULL;
		return data;
	}
	
	data = array[ROOT_NODE]; 
	return data;	
}


//----------------
template <class DATA>
DATA* Heap<DATA>::ptop()
{
	return &array[ROOT_NODE]; 	
}

//----------------
template <class DATA>
DATA Heap<DATA>::get()
{
	DATA data;

	int cur_node;
	int l_node;
	int r_node;

	int min_node;
	int last_node;

	bool modified;
	
	//-- check if heap is empty --
	if (array_sz == 0)
	{
		//printf("\nHeap<DATA>::get(): error -- q is empty\n");
		//data = (DATA)NULL;
		data.key = -1;
		return data; //retun random stuff 
	}
	
	//-- remove root --
	data = array[ROOT_NODE]; 
	
	//-- put last elem in place of root --
	array_sz --;
	array[ROOT_NODE] = array[ROOT_NODE + array_sz];
	
	//-- do adjustments --
	cur_node  = ROOT_NODE;
	last_node = ROOT_NODE + array_sz - 1;
	
	modified = true;
	
	while (modified)
	{
		modified = false;
		
		l_node = L_CHILD(cur_node);
		r_node = R_CHILD(cur_node);

		if (l_node > last_node)
			break;

		if (r_node > last_node)
			r_node = l_node;
		
		if (array[l_node].key >= array[r_node].key)
			min_node = l_node;
		else
			min_node = r_node;
		
		if (array[cur_node].key < array[min_node].key)
		{
			DATA tmp = array[cur_node];
			array[cur_node] = array[min_node];
			array[min_node] = tmp;
			
			cur_node = min_node;
			modified = true;
		}
	}
	
	return data;
}

//-------------------------------------
template <class DATA>
void Heap<DATA>::print()
{
	printf("\nHEAP\n");
}



#endif 

