//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

// MVCI by Dmitri V. Kalashnikov 2002-08-25
#ifndef HEAP_HPP
#define HEAP_HPP 


#define GET_PARENT(node)	((node) / 2)
#define L_CHILD(node)		((node) * 2)
#define R_CHILD(node)		((node) * 2 + 1) 


const int ROOT_NODE = 1;

template <class DATA> 
class Heap 
{
private:
	// root is node #1, not #0
	DATA *array;
	int array_sz;

	int max_array_sz;

public:
	Heap(int max_array_sz);
	~Heap();

	void clean();
	bool isEmpty(); 
	bool isNotEmpty();

	DATA top();
	DATA* ptop();
	DATA get();
	void put(DATA data); 
 
	void print();
};



#include "Heap.cpp" //because of templates

#endif
