//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "../data/Choice.hpp"
#include "Config.hpp"
#include "DynArray.hpp"
#include "Timer.hpp"
#include "Util.hpp"

extern Config conf;
extern int gChoiceNodeT;

extern Hash<pFullNode> nodeTable; 
extern Hash<pFullEdge> edgeTable;
extern DynArray<pChoice> choiceTable;


typedef char *pchar;

void ltrim(char *s)
{
	int len = (int)strlen(s);
	if (len == 0) return;

	for (int i = len - 1; i >=0 && s[i] <= ' '; i --)
		s[i] = 0;
}


//-----------------------------------------------------------
void parseString(char* str, pchar *param, int &num_param)
{
	static char buf[10000];

	strncpy(buf, str, 10000);
	num_param = 0;

	ltrim(buf);
	//printf("\n%s",buf);

	int len = (int)strlen(buf);
	if (len == 0) return;


	//-- handle ending with a comma (,) separately --
	bool last_param;
	if (buf[len-1] == ',')	last_param = true;
	else 					last_param = false;


	//--
	int i_beg = 0;
	int i_end;

	while(i_beg < len)
	{
		if (buf[i_beg] == '\n')
		{
			return;
		}
		else if (buf[i_beg] <= 32) //leading whitespace
		{
			i_beg ++;
			continue;
		}
		else if (buf[i_beg] == '"') // handle '"xyz",' 
		{
			i_beg ++;

			for (i_end = i_beg; i_end < len; i_end ++)
			{
				if ( (buf[i_end] == '"' && buf[i_end + 1] == ',')  ||
					 (buf[i_end] == '"' && buf[i_end + 1] <= ' ') )
					break;
			}

			buf[i_end] = 0;
			param[num_param] = &buf[i_beg];
			num_param ++;

			//-- find new i_beg, ignore white space (e.g, '"   ,   xyz')-- 
			i_beg = i_end + 1;

			while (buf[i_beg] != ',' && buf[i_beg] != 0 && buf[i_beg] <= ' ')
				i_beg ++;
			
			//-- check if done or error --
			if (buf[i_beg] != ',')
			{
				if (buf[i_beg] > ' ')
				{
					printf("\n parseString(): error while parsing '%s'", buf);
					exit(-1);
				}

				return;
			}

			i_beg ++;
			 
		}
		else // handle '123,'    
		{
			for (i_end = i_beg; buf[i_end] != ',' && i_end < len; i_end ++)
				;

			param[num_param] = &buf[i_beg];
			num_param ++;

			buf[i_end] = 0;
			ltrim(&buf[i_beg]);

			i_beg = i_end + 1;
		}

		//printf("\n p[%d]=%s", num_param, param[num_param - 1]);
	}

	//--
	if (last_param) 
	{
		param[num_param] = &buf[len];
		num_param ++;
	}
}


//--
void loadNodes(char* filename)
{
	FILE *f;

	Timer timer;
	timer.start();
	printf("\n Loading nodes ... ");
	

	if ( (f = fopen(filename, "r")) == NULL)
	{
		printf("\n loadNodes(): Cannot open file '%s'\n\n", filename);
		exit(-1);
	}

	
	//-- load paper.txt --
	for (;;)
	{
		char str[10000];
		pchar param[1000];
		int num_param;

		//-- read one line --
		if (fgets(str, 10000, f) == NULL)
			break;

		//--
		ltrim(str);
		if (strlen(str) == 0)
			continue;

		parseString(str, param, num_param);


		//--
		if (num_param != 3 && num_param !=5)
		{
			printf("\n loadNodes(): There are %d params in '%s'", num_param, str);
			exit(-1);
		}
	
		int id		= atoi(param[0]); 
		int type	= atoi(param[1]);
		char* name	= param[2];

		
		//-- if choice, load the rest --
		if (type == gChoiceNodeT)
		{
			if ( num_param != 5)
			{
				printf("\n loadNodes(): Wrong number of params for choice node '%s': %d vs 5\n", str, num_param);
				exit(-1);
			}

			int cnt_fnode_id	= atoi(param[3]);
			int ans_fnode_id	= atoi(param[4]);

			new Choice(id, (char)type, name, cnt_fnode_id, ans_fnode_id, true);
		}
		else
		{
			new FullNode(id, (char)type, name, true);
		}

		//printf("\n %d, %d, %s", id, type, name);
		//node->print();
		//getchar();
		//printf("\n");
	}	

	printf("(total %d and %d choices) in %.3f secs", nodeTable.num_elem, choiceTable.cur_sz, timer.getTime());
}


//---------------------------------------------------------------
void loadEdges(char* filename)
{
	FILE *f;

	Timer timer;
	timer.start();
	printf("\n Loading edges ... ");
	

	//--
	if ( (f = fopen(filename, "r")) == NULL)
	{
		printf("\n loadEdges(): Cannot open file '%s'\n\n", filename);
		exit(-1);
	}


	//--
	for (;;)
	{
		char str[10000];
		pchar param[1000];
		int num_param;

		//-- read one line --
		if (fgets(str, 10000, f) == NULL)
			break;

		//--
		ltrim(str);
		if (strlen(str) == 0)
			continue;

		parseString(str, param, num_param);

		//printf("\n xyz num_param=%d", num_param);
		//getchar();

		int id		 = atoi(param[0]);
		int node_id1 = atoi(param[1]);
		int node_id2 = atoi(param[2]);
		int type     = atoi(param[3]);
		char* name   = param[4];
		
		new FullEdge(id, node_id1, node_id2, (char)type, name, true);
	}		

	
	
	printf("(total %d) in %.3f secs", edgeTable.num_elem, timer.getTime());
	//getchar();
}
