//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include <stdio.h>
#include <string.h>

#include "Config.hpp"
#include "DynArray.hpp"
#include "../data/Choice.hpp"
#include "../data/FullEdge.hpp"
#include "Hash.hpp"
#include "Rand.hpp"

extern Config conf;
extern DynArray<pChoice> choiceTable;
extern Hash<pFullEdge> edgeTable;


//---
void outputResults()
{
	FILE *f1 = NULL;
	FILE *f2 = NULL;
	char* str;
	//bool out_acc;
	bool save_file;
	bool save_details;


	//-- compute accuracy? --
	str = conf.get_str((char*)"OutputAccuracy");
	
	//if (strcmp(str, "Yes") == 0) out_acc = true;
	//else						 out_acc = false;

	
	//-- save output to file? --
	str = conf.get_str((char*)"SaveFile");

	if (strcmp(str, "Yes") == 0)
	{
		save_file = true;

		if ( (f1 = fopen(conf.get_str((char*)"SaveFileName"), "w+b")) == NULL)
		{	printf("\n outputResults() : cannot open file"); getchar(); exit(-1); }
	}
	else save_file = false;


	//-- save output to file? --
	str = conf.get_str((char*)"SaveDetailedFile");

	if (strcmp(str, "Yes") == 0)
	{
		save_details = true;

		if ( (f2 = fopen(conf.get_str((char*)"SaveDetailedFileName"), "w+b")) == NULL)
		{ 	printf("\n outputResults() : cannot open file"); getchar(); exit(-1); }
	}
	else save_details = false;

	double num_hits = 0;
	double fbs_hits = 0;
	int num_cho = choiceTable.cur_sz;

	//-- process each choice --
	for (int i = 0; i < num_cho; i++)
	{
		pChoice cho = choiceTable.arr[i];

		//-- not efficient, but consistent with the policy in propagateWeights() --
		cho->propagateWeights();

		double max_w = -1;
		int num_same_w = 0;
		pFullEdge max_edge = NULL;

		//--
		for (int j = 0; j < cho->num_opt; j++)
		{
			int edge_id = cho->edges.arr[j];
			pFullEdge edge = edgeTable.get(edge_id);

			if (edge->w > max_w) 
			{ 
				num_same_w = 1;
				max_w	  = edge->w; 
				max_edge  = edge; 
			}
			else if (edge->w == max_w) 
			{
				num_same_w ++;
			}

			if (save_details)
			{
				int opt_fnode_id;
				char c;
				
				if (edge->fnode_id1 == cho->id) opt_fnode_id = edge->fnode_id2;
				else							opt_fnode_id = edge->fnode_id2;

				if (opt_fnode_id == cho->ans_fnode_id) c = '*';
				else                                   c = ' ';  

				fprintf(f2, "%d %d %f %c\n", cho->id, opt_fnode_id, edge->w, c); 
			}
		}


		//-- if >2 edges with the same weight, choose one *randomly* --
		if (num_same_w > 1)
		{
			int rnd_num = (int) (double(num_same_w) * Rand::rnd());
			int j, k;

			for (j = 0, k = 0; j < cho->num_opt; j++)
			{
				int edge_id = cho->edges.arr[j];
				pFullEdge edge = edgeTable.get(edge_id);

				if (edge->w == max_w) 
				{ 
					k ++;

					if (k > rnd_num)
					{
						max_edge  = edge; 
						break;
					}
				}
			}
		}


		//-- determine who is the anwser --
		int ans_fnode_id;
		char s[100];
		
		if (max_edge->fnode_id1 == cho->id)  ans_fnode_id = max_edge->fnode_id2;
		else								 ans_fnode_id = max_edge->fnode_id1;

		if (ans_fnode_id == cho->ans_fnode_id)
		{
			num_hits++;
			strcpy(s, "+");
		}
		else if (cho->ans_fnode_id < 0) strcpy(s, "?");
		else sprintf(s, "%d", cho->ans_fnode_id);

		fbs_hits += 1.0 / cho->num_opt;

		fprintf(f1, "%d %d %s\n", cho->id, ans_fnode_id, s); 

		//fprintf(f1, "%d %d %d %c\n", cho->id, max_edge->id, ans_fnode_id, c); 
		
	}

	if (num_cho == 0) printf("\n Zero choice nodes!");
	else
	{
		double fbs_acc = double(fbs_hits) / num_cho;
		double rdc_acc = double(num_hits) / num_cho;

		printf("\n FBS accuracy=%f, RelDC accuracy = %f, Number of choices = %d", 
		fbs_acc, rdc_acc, num_cho);

		double unc_frac = conf.get_double((char*)"FracUncRef");
		double cer_frac = 1 - unc_frac;

		printf("\n FBS_acc_wfrac=%f, RelDC_acc_wfrac = %f\n\n\n", 
		cer_frac * 1 + unc_frac * fbs_acc, cer_frac * 1 + unc_frac * rdc_acc);
	}


	//---
	if (save_file   ) fclose(f1);
	if (save_details) fclose(f2);


}

