//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

// MVCI by Dmitri V. Kalashnikov 2002-08-24

//#define _USE_MATH_DEFINES //dvk for M_PI

//#include <stdio.h>
#include <math.h> 

//#include "../const.h"
 
 
#include "Rand.hpp" 
 
//------------------------------------- 
double Rand::rnd() 
{ 
	const double d2p31m = 2147483647.0; 
	const double d2p31  = 2147483711.0; 
 
	static double seed = 1234567.0; //init only one time 
 
	seed = 16807 * seed - floor(16807 * seed / d2p31m) * d2p31m; 
 
	return fabs(seed / d2p31);  
}  

//-------------------------------------  
double Rand::rnd(double lo, double hi)
{
	return lo + (hi - lo) * rnd();
}
 
//-------------------------------------  
double Rand::rndNormal01()  
{ 
	double v1, v2, s; 
 
	do 
	{ 
		v1 = 2 * rnd() - 1; 
		v2 = 2 * rnd() - 1; 
 
		s = v1 * v1 + v2 * v2; 
	} 
	while (s >= 1); 
 
	return v1 * sqrt((- 2 * log(s)) / s); 
} 
 
//-------------------------------------  
double Rand::rndNormal(double mean, double stddev) 
{ 
	return stddev * rndNormal01() + mean; 
} 

//-------------------------------------  
double Rand::rndTruncNormal(double mean, double stddev, double lo, double hi)
{
	double a = lo - 1;

	while (a < lo || a > hi)
	{
		a = rndNormal(mean, stddev);
	}

	return a;
}

//-------------------------------------  
int Rand::rndIntTruncNormal(double mean, double stddev, int lo, int hi)
{
	int a = lo - 1;

	while (a < lo || a > hi)
	{
		a = (int)rndNormal(mean, stddev);
	}

	return a;
}

//------------------
double Rand::expon(double mean) //mean is A - mean interarrival; NOT lambda = 1/A - arrival rate
{
    return  - mean * log (rnd())  ;
}
 

//-- END OF FILE --
