//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#include "../data/Node.hpp"

#include "Timer.hpp"
#include "Util.hpp"

#include "../const.hpp"


void saveGraphForVis(char *filename)
{
	Timer timer;
	timer.start();
	printf("\n Saving graph for visualization ... ");

	FILE *f;

	if ( (f = fopen(filename, "w")) == NULL)
	{
		printf("\n saveGraphForVis(): Cannot open file '%s'\n\n", filename);
		exit(-1);
	}

	fprintf(f, "graph: {title: \"force-directed layout\"\n");
    fprintf(f, "  layoutalgorithm: forcedir\n");
    fprintf(f, "  gravity        : 0.0\n");  
    fprintf(f, "  repulsion      : 400\n");
    fprintf(f, "  attraction     : 60\n");
    fprintf(f, "  arrowmode      : free\n");
    fprintf(f, "  magnetic_field1: polar\n");
    fprintf(f, "  magnetic_field2: no\n\n");

	//-- save nodes --
	for (int i = 0; i < nodeTable.num_bucket; i++)
	{
		for (int j = 0; j < nodeTable.bucket[i].cur_sz; j++)
		{
			pFullNode fnode = nodeTable.bucket[i].arr[j].val;
			fnode->save(f);
		}
	}

	//-- save edges --
	for (int i = 0; i < edgeTable.num_bucket; i++)
	{
		for (int j = 0; j < edgeTable.bucket[i].cur_sz; j++)
		{
			pFullEdge fedge = edgeTable.bucket[i].arr[j].val;
			fedge->save(f);
		}
	}

	fprintf(f,"}");

	fclose(f);
	printf("%.3f secs", timer.getTime());
}
