//Copyright (c) 2013, Dmitri V. Kalashnikov. All rights reserved.
//This copyright notice should remain at the top of this file.
//

#ifndef UTIL_HPP
#define UTIL_HPP

#include "../data/Choice.hpp"
#include "../data/FullNode.hpp"
#include "../data/FullEdge.hpp"
#include "../data/Node.hpp"
#include "../nbh/GrdNBH.hpp"
#include "../util/Timer.hpp"


#include "Hash.hpp"
#include "HashStr.hpp"

class Node;
class GrdNBH;

//-- AllPaths --
extern int grdAllPathsNBH(pNode srcNode, GrdNBH *nbh, int L, int N_exp, pNode nodeArr, pChoice cho, int opt_no);

//-- Load Data --
extern void loadNodes(char* filename);
extern void loadEdges(char* filename);

//-- Compact Graph --
extern void createCompactNodeArray(Node* &nodeArr, Hash<pFullNode> &nodeTable, Hash<pFullEdge> &edgeTable);

//--
extern void multiThreadScheduler(int goal);

extern void computePathWeight(int *path, int path_sz, double &fix_w, double &dyn_w, bool &is_fixed);

extern void GenerateChoices(void);


#endif
