%GPR_plot_arrow(x, y, theta, tau, sigma_t, Myaxis, whether_plot_point)
%Plot the graphic of Gaussian Process Regression with time shifts
% 
%
function [h, x_star, y_smean] = GPR_plot_arrow(x, y, theta, tau, sigma_t, Myaxis, whether_plot_point)

l = theta(1); sigma_n = theta(2); sigma_f = theta(3);
if nargin <=3
    tau = zeros(size(x));
end

r2 =(max(x)-min(x));
N = 1e2; % How many points to use
z = .1; % How much to extend the time series on either side (e.g. .5 is 50% extension on left and on right)
x_star = (0:(N-1))/(N-1) * (z*2+1)*r2 + min(x)-r2*z;


%%%%%%%%%%2.) Calculating mu and sigma %%%%%%%%%%%%%%%
y_smean = zeros(N,1); 
y_svar = zeros(N,1);

for i = 1:N
     [mu_star, sigma_star] = mu_sigma(x_star(i), x-tau, y, theta);
     y_smean(i) = mu_star;
     y_svar(i) = sigma_star;
     
end
  
y_sbias = 1.96 * sqrt(y_svar);
bounds = [ y_smean + y_sbias, y_smean - y_sbias];
%%%%%%%%%3.) Ploting %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h = figure;
hold on
%mycolor = [255, 248, 231]/255; %Cosmic Latte, the color of the
                                %confidential intervals
%mycolor = [245, 245, 220]/255; %beige
mycolor = [237, 201, 175]/255; %Desert Sand


plot(x_star, y_smean + y_sbias, '--', 'color', mycolor);
plot(x_star, y_smean - y_sbias, '--', 'color', mycolor);
stdRegion (x_star,bounds, mycolor);

if nargin < 6
    Myaxis = [21, 46, -8, 6];
end
axis tight;
    v = axis;
    axis(Myaxis);
    set(gca, 'XTick', v(1):5:v(2));
    hx = xlabel('Time'); set(hx, 'FontSize', 16);
    set(gca, 'XTick', 21:2:46);
    hy = ylabel('Gene Expression'); set(hy, 'FontSize', 16);
    
plot(x_star,y_smean,'b-','LineWidth',2);%1.5);
if (nargin < 7)|| (whether_plot_point ~= 0)
    plot(x,y,'bo','MarkerSize', 6, 'MarkerFaceColor', 'b');
    if any(tau)
           pst = get(gca, 'position');
    v = axis;
    for i = 1:length(x)
        x_pst = pst(1) + (x(i) - v(1))/(v(2)-v(1))*pst(3);
        y_pst = pst(2) + (y(i) - v(3))/(v(4) - v(3))*pst(4);
        tau_pst = tau(i)/(v(2)-v(1))*pst(3); 
        hl = annotation('arrow', [x_pst, x_pst - tau_pst], [y_pst, y_pst], 'Color', 'black');
        set(hl, 'LineWidth', 1, 'HeadStyle', 'vback3', 'HeadLength', 8, 'HeadWidth',8);
        if i == 11
            set(hl, 'Color', 'Red', 'LineWidth', 1.5);
        end
  
    end

    end
end



hold off


