% input:  [ (x_i-tau_i), (x_j-tau_j), l, sigma_f] 
% output: [ k_ij, dkdtau_ij, ddkddtau_ij]
% verified, no bugs;

function [k, dkdtaui, ddkddtaui]=k_ij(x_i, x_j, l, sigma_f)

k = sigma_f^2 * exp( -(x_i-x_j)^2*l^(-2)/2 );
if nargout > 1
    dkdtaui = (x_i - x_j)*l^(-2) * k;
    ddkddtaui = ((x_i - x_j)^2*l^(-4) - l^(-2)) * k;
end


    



