% [k, k_grad_tau, k_grad_l, k_grad_sigma_f]=k_matrix(x, l, sigma_f)
%
%k_grad_tau(:, :, i) is dk/dtau_i
%
% verfied by [k, k_tau, k_theta] = k_matrix([1,3]', 2,3)

function [k, k_grad_tau, k_grad_l, k_grad_sigma_f]=k_matrix(x, l, sigma_f)
n = length(x);
k = zeros(n);


for i = 1: n
    for j = 1: n
        k(i,j) = k_ij(x(i), x(j), l, sigma_f);
    end 
end

if nargout >= 2
    k_grad_tau = zeros(n, n, n); 
    for i = 1:n
        k_grad_tau(i, :, i) = (x(i) - x)'.*k(i, :)/l^2;
        k_grad_tau(:, i, i) = (x(i) - x) .*k(:, i)/l^2;
    end
end


if nargout >= 3
    k_grad_l = zeros(n, n);
    k_grad_sigma_f = zeros(n,n);
    for i =  1:n 
        for j = 1: n
            k_grad_l(i,j) = (x(i)-x(j))^2 * l^(-3) * k(i, j);
            k_grad_sigma_f(i,j) = 2 * sigma_f^(-1) * k(i, j);
        end
    end

end





%--------testing in two dimension and the results:
%[k, k_tau, k_theta] = k_matrix([1,3]', 2,3)

%k =

  %  9.0000    5.4588
 %   5.4588    9.0000


%k_tau(:,:,1) =

  %       0   -2.7294
 %  -2.7294         0


%k_tau(:,:,2) =

  %       0    2.7294
 %   2.7294         0


%k_theta(:,:,1) =

    %     0    2.7294
   % 2.7294         0


%k_theta(:,:,2) =

 %   6.0000    3.6392
  %  3.6392    6.0000


