%function err = loocv_mse(x, y_test, para, ind_knock)
% if nargin <= 3 Leave one out cross validation, i.e., leave one replicates out, and repeat this process until all replicates are leave out once;
% if nargin >= 4 random chose one replicates at each time point;
% The output is row vector in both case.

function err_Vec = loocv_mse(x, y_test, para_xv, ind_knock)

if nargin <= 3
    for stp = [1:24]
        % deciding the knocked-out replicates
        numrep =  [2     2     3     3     2     3     3     3     3];
        ind_knock = stp; %1 + [2,4, 7, 10, 12, 15,18,21,24]' - rand_integer(numrep, 1, 9)';%[2,4, 7, 10, 12, 15,18,21,24]';
        luo = [1:length(x)]' ~= ind_knock(1);
        for i = 2:length(ind_knock)
            luo  = luo.*([1:length(x)]' ~= ind_knock(i));
        end
        indk = find(luo);
        
       % calculate the mean squared error
        for i = 1:length(ind_knock)
            for j = 1:size(y_test, 2)
                y_est(i, j) = mu_sigma(x(ind_knock(i))-para_xv(ind_knock(i)), x(indk)-para_xv(indk), y_test(indk, j), para_xv(end-2:end));
            end
            err(i) = mean((y_est(i,:)-y_test(ind_knock(i),:)).^2);
        end
        err_Vec(:, stp) = err';
    end
end

if nargin >=4
    luo = [1:length(x)]' ~= ind_knock(1);
    for i = 2:length(ind_knock)
         luo  = luo.*([1:length(x)]' ~= ind_knock(i));
    end
    indk = find(luo);
        
       % calculate the mean squared error
    for i = 1:length(ind_knock)
        for j = 1:size(y_test, 2)
            y_est(i, j) = mu_sigma(x(ind_knock(i))-para_xv(ind_knock(i)), x(indk)-para_xv(indk), y_test(indk, j), para_xv(end-2:end));
        end
        err_Vec(i) = mean((y_est(i,:)-y_test(ind_knock(i),:)).^2);
    end
end

    
