%% This file use matlab cell mode. To run the cells, use Ctrl+Enter. 


%% Estimate the time shifts and GP paramters by maximizing the posterior 
%%   distribution with different values of sigma_tau
load gene_data;
x = time_point;
y = gene_data; % the gene expression data
n = length(x);

sigma_t_Vec =[0.0250, 0.05:0.05:2]; % specify values of sigma_tau
Nsigma_t = length(sigma_t_Vec);
para_best = zeros(n + 3, Nsigma_t);
Nstarts = 10; % repeat fminunc optimization for Nstarts times starting from random initial values.

for i = 1 : Nsigma_t
    sigma_t = sigma_t_Vec(i);
    para_best(:, i) = max_tau_gene(x, y,sigma_t, Nstarts);
end
%% Estimate GP parameters theta when sigma_tau = 0, i.e., no time shifts
%% are included
x = time_point;
y = gene_data;
sigma_t = 1;
Nstarts = 10;
theta_st = max_theta_only(x, y, Nstarts);


%% plot the profile
x = time_point;
sigma_t = 1;
index_collection = [1617,5986, 1307];
title_str =  name_id(index_collection); 
for j =1:length(index_collection)
    % plot the curve fitting with time shifts
    theta_fit = para_best(end-2:end, find(sigma_t_Vec == sigma_t));  
    tau_fit  =  para_best(1:end-3, find(sigma_t_Vec == sigma_t)); 
    y_plot = gene_data(:, index_collection(j));
    GPR_plot_arrow(x,y_plot, theta_fit ,tau_fit, sigma_t);
    title([]);
    text(21.5,5, title_str(j), 'FontSize', 16);
    hold off
    
    % plot the curve fitting without time shifts
    theta_fit = theta_st; 
    tau_fit = zeros(24,1);
    y_plot = gene_data(:, index_collection(j));
    GPR_plot_arrow(x,y_plot, theta_fit ,tau_fit, sigma_t);
    title([]);
    text(21.5,5, title_str(j), 'FontSize', 16);
    hold off
end


%%  Calculating the p_value
rank_expert = [1,2, 1,2, 3,1,2, 1,2,3, 2,1,  1,3,2, 3,2,1,  1,3,2,  1, 2, 3]; 
MM = 60000;
mm = 0;
pp = 0;
n = length(x);
corri_Vec = [];
while mm < MM
    mm = mm + 1;
    for i = 1:length(time_p2)
        corri(i) = xcov(randperm(length(find(x==time_p2(i)))), rank_expert(find(x == time_p2(i))), 0, 'coef');
    end
    corri_Vec =[corri_Vec, mean(corri)];
end
length(corri_Vec)
p_value = nnz(find((corri_Vec >=0.6667)))/length(corri_Vec); 


