%Estimate the time shifts and GP parameters by maximize the posterior distribution.  
%Usage: [para_best, para_opt_Vec, fva_Vec]=max_tau_gene(x, y, sigma_t, Nstarts)
%Inputs: 
%-----x:  time points;      
%-----y: the gene data;   
%-----Nstarts: repeat the fminunc function for Nstarts times from random initial values
%Outputs:
%-----para_best = [tau; l; sigma_n; sigma_f]; 

function [para_best, para_opt_Vec, fva_Vec]=max_tau_gene(x, y, sigma_t, Nstarts)

n = length(x);

options = optimset('GradObj', 'on');
inits = randn(n ,Nstarts)*0.5*sigma_t;
l_inits = hypsample([1  (max(x) - min(x))], Nstarts);
sf_inits = hypsample([0.1*mean(mean((abs(diff(y))))) 1.5*mean(mean((abs(diff(y)))))], Nstarts);
sn_inits = hypsample([0.05 0.5], Nstarts);
inits = [inits; l_inits'; sn_inits'; sf_inits'];

para_opt_Vec = [];
fva_Vec = [];
for i=1: Nstarts
    [para_opt, fva] = fminunc(@(para) neglogp_tau_all(para, x, y, sigma_t ), inits(:,i), options);
    para_opt_Vec=[para_opt_Vec, para_opt];
    fva_Vec = [fva_Vec, fva];
end

[f_best, index_best] = min(fva_Vec);
para_best = para_opt_Vec(:,index_best);


