%function [para_best, para_opt_Vec]=max_theta_only(x, y,sigma_t, Nstarts)


function [para_best, para_opt_Vec]=max_theta_only(x, y, Nstarts)

n = length(x);

options = optimset('GradObj', 'on');
inits = [];
l_inits = hypSample([1 (max(x) - min(x))*5], Nstarts);
sf_inits = hypSample([0.1*mean(mean((abs(diff(y))))) 1.5*mean(mean((abs(diff(y)))))], Nstarts);
sn_inits = hypSample([0.05 0.5], Nstarts);
inits = [inits; l_inits'; sn_inits'; sf_inits'];

para_opt_Vec = [];
fva_Vec = [];
for i=1: Nstarts
    [para_opt, fva] = fminunc(@(theta) neglogp_theta_only(theta,x, y, 1), inits(:,i), options);
    para_opt_Vec=[para_opt_Vec, para_opt];
    fva_Vec = [fva_Vec, fva];
end
[f_best, index_best] = min(fva_Vec);
para_best = para_opt_Vec(:,index_best);
 
    
    
    
    
