% Input: [x*, x-tau, y, theta], where 
%         theta = [l, sigma_n, sigma_f]'; 
%         x,y: are column vectors, the observed data;
%         tau: the bias in x;
%        y* : scalar number, for prediction; 
%
% Output: [mu*, sigma*, ddmu*_ddtau, ddsigma*_ddtau]
% Denpencies: f_ij.m
% verified for one dimension 

function [mu, sigma, ddmuddtau, ddsigmaddtau] = mu_sigma(x_star, x, y, theta)

%%%%%%%%% 1.) calculate matrix k k* k** and ddkddtau %%%%%%%%%%%%%%
 l=theta(1); sigma_n=theta(2); sigma_f=theta(3);
 
 n=size(x, 1);
 
 k=zeros(n); 
 k_star=zeros(n, 1);
 dk=zeros(n);
 ddk=zeros(n);
 dk_star = zeros(n, 1);
 ddk_star = zeros(n,1);
 
 for i = 1:n
     for j = 1:n
         [k(i, j), dk(i, j), ddk(i,j)] = k_ij(x(i), x(j), l, sigma_f);
     end
     [k_star(i), dk_star(i), ddk_star(i)] = k_ij(x(i), x_star, l, sigma_f);
 end
 k_ss = k_ij(x_star, x_star, l, sigma_f);
 
 %%%%%%%%% 2.) calculate mu_star, sigma_star %%%%%%%%%%%%%%%%%%%%%%%%%%%
 diags = max(1e3*eps, sigma_n^2); % beef up the diagonal if sigma_n = 0
 L = chol (k + diags*eye(n),'lower'); 
 alpha = L\[y, k_star];
 mu = alpha(:, 2)'*alpha(:, 1);
 sigma = k_ss - alpha(:, 2)'*alpha(:, 2);
 %mu = k_star'*((k + sigma_n*eye(n))\y);
 %sigma = k_ss - k_star'*((k+sigma_n*eye(n))\k_star);
 
 
 
 %%%%%%%% 3.) calculate ddmu_starddtau, ddsigma_starddtau %%%%%%%%%%%%%%%
 if nargout <= 2
     return
 end
 
 ddmuddtau=zeros(n, 1);
 ddsigmaddtau=zeros(n, 1);
 
 for i = 1:n
     dkdtaui = zeros(n);
     ddkddtaui = zeros(n);
     dkdtaui(i, :) = dk(i, :);
     dkdtaui(:, i) = dk(:, i);
     dkdtaui(i, i) = 0;
     ddkddtaui(i, :) = ddk(i, :);
     ddkddtaui(:, i) = ddk(:, i);
     ddkddtaui(i, i) = 0;
     
     dk_sdtaui = zeros(n, 1);
     ddk_sddtaui = zeros(n, 1);
     dk_sdtaui(i) = dk_star(i);
     ddk_sddtaui(i) = ddk_star(i);
     
     %dkdtaui, ddkddtaui, dk_sdtaui,  ddk_sddtaui
     
     alpha = L'\(L\[y, k_star, dk_sdtaui, ddk_sddtaui, dkdtaui]);
     beta =  (ddk_sddtaui' - 2*alpha(:, 3)'*dkdtaui + 2*k_star'*alpha(:,5:4+n)*alpha(:,5:4+n) - alpha(:, 2)'*ddkddtaui) * alpha(:, 1:2) ;
     ddmuddtau(i) = beta(1);
     ddsigmaddtau(i) = - ( beta(2) + 2*dk_sdtaui'*alpha(:, 3) - 2*alpha(:, 2)'*dkdtaui*alpha(:,3) + alpha(:, 2)'*ddk_sddtaui);
        
 end
 
     
     
     
         
         
 